/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.CancelStepsRequestStatus;
import software.amazon.awssdk.services.emr.transform.CancelStepsInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelStepsInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, CancelStepsInfo> {
    private final String stepId;
    private final String status;
    private final String reason;

    private CancelStepsInfo(BuilderImpl builder) {
        this.stepId = builder.stepId;
        this.status = builder.status;
        this.reason = builder.reason;
    }

    public String stepId() {
        return this.stepId;
    }

    public CancelStepsRequestStatus status() {
        return CancelStepsRequestStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String reason() {
        return this.reason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stepId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelStepsInfo)) {
            return false;
        }
        CancelStepsInfo other = (CancelStepsInfo)obj;
        return Objects.equals(this.stepId(), other.stepId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.reason(), other.reason());
    }

    public String toString() {
        return ToString.builder((String)"CancelStepsInfo").add("StepId", (Object)this.stepId()).add("Status", (Object)this.statusAsString()).add("Reason", (Object)this.reason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StepId": {
                return Optional.ofNullable(clazz.cast(this.stepId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CancelStepsInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String stepId;
        private String status;
        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelStepsInfo model) {
            this.stepId(model.stepId);
            this.status(model.status);
            this.reason(model.reason);
        }

        public final String getStepId() {
            return this.stepId;
        }

        @Override
        public final Builder stepId(String stepId) {
            this.stepId = stepId;
            return this;
        }

        public final void setStepId(String stepId) {
            this.stepId = stepId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CancelStepsRequestStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public CancelStepsInfo build() {
            return new CancelStepsInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CancelStepsInfo> {
        public Builder stepId(String var1);

        public Builder status(String var1);

        public Builder status(CancelStepsRequestStatus var1);

        public Builder reason(String var1);
    }
}

