/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.ScalingTrigger;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ScalingTriggerMarshaller {
    private static final MarshallingInfo<StructuredPojo> CLOUDWATCHALARMDEFINITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CloudWatchAlarmDefinition").isBinary(false).build();
    private static final ScalingTriggerMarshaller INSTANCE = new ScalingTriggerMarshaller();

    private ScalingTriggerMarshaller() {
    }

    public static ScalingTriggerMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ScalingTrigger scalingTrigger, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)scalingTrigger, (String)"scalingTrigger");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)scalingTrigger.cloudWatchAlarmDefinition(), CLOUDWATCHALARMDEFINITION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

