/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.InstanceTypeConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InstanceTypeConfigMarshaller {
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").isBinary(false).build();
    private static final MarshallingInfo<Integer> WEIGHTEDCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WeightedCapacity").isBinary(false).build();
    private static final MarshallingInfo<String> BIDPRICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BidPrice").isBinary(false).build();
    private static final MarshallingInfo<Double> BIDPRICEASPERCENTAGEOFONDEMANDPRICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BidPriceAsPercentageOfOnDemandPrice").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> EBSCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EbsConfiguration").isBinary(false).build();
    private static final MarshallingInfo<List> CONFIGURATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Configurations").isBinary(false).build();
    private static final InstanceTypeConfigMarshaller INSTANCE = new InstanceTypeConfigMarshaller();

    private InstanceTypeConfigMarshaller() {
    }

    public static InstanceTypeConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstanceTypeConfig instanceTypeConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)instanceTypeConfig, (String)"instanceTypeConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)instanceTypeConfig.instanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)instanceTypeConfig.weightedCapacity(), WEIGHTEDCAPACITY_BINDING);
            protocolMarshaller.marshall((Object)instanceTypeConfig.bidPrice(), BIDPRICE_BINDING);
            protocolMarshaller.marshall((Object)instanceTypeConfig.bidPriceAsPercentageOfOnDemandPrice(), BIDPRICEASPERCENTAGEOFONDEMANDPRICE_BINDING);
            protocolMarshaller.marshall((Object)instanceTypeConfig.ebsConfiguration(), EBSCONFIGURATION_BINDING);
            protocolMarshaller.marshall(instanceTypeConfig.configurations(), CONFIGURATIONS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

