/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.Ec2InstanceAttributes;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class Ec2InstanceAttributesMarshaller {
    private static final MarshallingInfo<String> EC2KEYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ec2KeyName").isBinary(false).build();
    private static final MarshallingInfo<String> EC2SUBNETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ec2SubnetId").isBinary(false).build();
    private static final MarshallingInfo<List> REQUESTEDEC2SUBNETIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequestedEc2SubnetIds").isBinary(false).build();
    private static final MarshallingInfo<String> EC2AVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ec2AvailabilityZone").isBinary(false).build();
    private static final MarshallingInfo<List> REQUESTEDEC2AVAILABILITYZONES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequestedEc2AvailabilityZones").isBinary(false).build();
    private static final MarshallingInfo<String> IAMINSTANCEPROFILE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IamInstanceProfile").isBinary(false).build();
    private static final MarshallingInfo<String> EMRMANAGEDMASTERSECURITYGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmrManagedMasterSecurityGroup").isBinary(false).build();
    private static final MarshallingInfo<String> EMRMANAGEDSLAVESECURITYGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmrManagedSlaveSecurityGroup").isBinary(false).build();
    private static final MarshallingInfo<String> SERVICEACCESSSECURITYGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceAccessSecurityGroup").isBinary(false).build();
    private static final MarshallingInfo<List> ADDITIONALMASTERSECURITYGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdditionalMasterSecurityGroups").isBinary(false).build();
    private static final MarshallingInfo<List> ADDITIONALSLAVESECURITYGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdditionalSlaveSecurityGroups").isBinary(false).build();
    private static final Ec2InstanceAttributesMarshaller INSTANCE = new Ec2InstanceAttributesMarshaller();

    private Ec2InstanceAttributesMarshaller() {
    }

    public static Ec2InstanceAttributesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Ec2InstanceAttributes ec2InstanceAttributes, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)ec2InstanceAttributes, (String)"ec2InstanceAttributes");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)ec2InstanceAttributes.ec2KeyName(), EC2KEYNAME_BINDING);
            protocolMarshaller.marshall((Object)ec2InstanceAttributes.ec2SubnetId(), EC2SUBNETID_BINDING);
            protocolMarshaller.marshall(ec2InstanceAttributes.requestedEc2SubnetIds(), REQUESTEDEC2SUBNETIDS_BINDING);
            protocolMarshaller.marshall((Object)ec2InstanceAttributes.ec2AvailabilityZone(), EC2AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall(ec2InstanceAttributes.requestedEc2AvailabilityZones(), REQUESTEDEC2AVAILABILITYZONES_BINDING);
            protocolMarshaller.marshall((Object)ec2InstanceAttributes.iamInstanceProfile(), IAMINSTANCEPROFILE_BINDING);
            protocolMarshaller.marshall((Object)ec2InstanceAttributes.emrManagedMasterSecurityGroup(), EMRMANAGEDMASTERSECURITYGROUP_BINDING);
            protocolMarshaller.marshall((Object)ec2InstanceAttributes.emrManagedSlaveSecurityGroup(), EMRMANAGEDSLAVESECURITYGROUP_BINDING);
            protocolMarshaller.marshall((Object)ec2InstanceAttributes.serviceAccessSecurityGroup(), SERVICEACCESSSECURITYGROUP_BINDING);
            protocolMarshaller.marshall(ec2InstanceAttributes.additionalMasterSecurityGroups(), ADDITIONALMASTERSECURITYGROUPS_BINDING);
            protocolMarshaller.marshall(ec2InstanceAttributes.additionalSlaveSecurityGroups(), ADDITIONALSLAVESECURITYGROUPS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

