/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.Cluster;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ClusterMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> EC2INSTANCEATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ec2InstanceAttributes").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCECOLLECTIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceCollectionType").isBinary(false).build();
    private static final MarshallingInfo<String> LOGURI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogUri").isBinary(false).build();
    private static final MarshallingInfo<String> REQUESTEDAMIVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequestedAmiVersion").isBinary(false).build();
    private static final MarshallingInfo<String> RUNNINGAMIVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RunningAmiVersion").isBinary(false).build();
    private static final MarshallingInfo<String> RELEASELABEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReleaseLabel").isBinary(false).build();
    private static final MarshallingInfo<Boolean> AUTOTERMINATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoTerminate").isBinary(false).build();
    private static final MarshallingInfo<Boolean> TERMINATIONPROTECTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TerminationProtected").isBinary(false).build();
    private static final MarshallingInfo<Boolean> VISIBLETOALLUSERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VisibleToAllUsers").isBinary(false).build();
    private static final MarshallingInfo<List> APPLICATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Applications").isBinary(false).build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").isBinary(false).build();
    private static final MarshallingInfo<String> SERVICEROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceRole").isBinary(false).build();
    private static final MarshallingInfo<Integer> NORMALIZEDINSTANCEHOURS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NormalizedInstanceHours").isBinary(false).build();
    private static final MarshallingInfo<String> MASTERPUBLICDNSNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MasterPublicDnsName").isBinary(false).build();
    private static final MarshallingInfo<List> CONFIGURATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Configurations").isBinary(false).build();
    private static final MarshallingInfo<String> SECURITYCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityConfiguration").isBinary(false).build();
    private static final MarshallingInfo<String> AUTOSCALINGROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoScalingRole").isBinary(false).build();
    private static final MarshallingInfo<String> SCALEDOWNBEHAVIOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScaleDownBehavior").isBinary(false).build();
    private static final MarshallingInfo<String> CUSTOMAMIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomAmiId").isBinary(false).build();
    private static final MarshallingInfo<Integer> EBSROOTVOLUMESIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EbsRootVolumeSize").isBinary(false).build();
    private static final MarshallingInfo<String> REPOUPGRADEONBOOT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RepoUpgradeOnBoot").isBinary(false).build();
    private static final ClusterMarshaller INSTANCE = new ClusterMarshaller();

    private ClusterMarshaller() {
    }

    public static ClusterMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Cluster cluster, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)cluster, (String)"cluster");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)cluster.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)cluster.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)cluster.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)cluster.ec2InstanceAttributes(), EC2INSTANCEATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)cluster.instanceCollectionTypeAsString(), INSTANCECOLLECTIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)cluster.logUri(), LOGURI_BINDING);
            protocolMarshaller.marshall((Object)cluster.requestedAmiVersion(), REQUESTEDAMIVERSION_BINDING);
            protocolMarshaller.marshall((Object)cluster.runningAmiVersion(), RUNNINGAMIVERSION_BINDING);
            protocolMarshaller.marshall((Object)cluster.releaseLabel(), RELEASELABEL_BINDING);
            protocolMarshaller.marshall((Object)cluster.autoTerminate(), AUTOTERMINATE_BINDING);
            protocolMarshaller.marshall((Object)cluster.terminationProtected(), TERMINATIONPROTECTED_BINDING);
            protocolMarshaller.marshall((Object)cluster.visibleToAllUsers(), VISIBLETOALLUSERS_BINDING);
            protocolMarshaller.marshall(cluster.applications(), APPLICATIONS_BINDING);
            protocolMarshaller.marshall(cluster.tags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)cluster.serviceRole(), SERVICEROLE_BINDING);
            protocolMarshaller.marshall((Object)cluster.normalizedInstanceHours(), NORMALIZEDINSTANCEHOURS_BINDING);
            protocolMarshaller.marshall((Object)cluster.masterPublicDnsName(), MASTERPUBLICDNSNAME_BINDING);
            protocolMarshaller.marshall(cluster.configurations(), CONFIGURATIONS_BINDING);
            protocolMarshaller.marshall((Object)cluster.securityConfiguration(), SECURITYCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)cluster.autoScalingRole(), AUTOSCALINGROLE_BINDING);
            protocolMarshaller.marshall((Object)cluster.scaleDownBehaviorAsString(), SCALEDOWNBEHAVIOR_BINDING);
            protocolMarshaller.marshall((Object)cluster.customAmiId(), CUSTOMAMIID_BINDING);
            protocolMarshaller.marshall((Object)cluster.ebsRootVolumeSize(), EBSROOTVOLUMESIZE_BINDING);
            protocolMarshaller.marshall((Object)cluster.repoUpgradeOnBootAsString(), REPOUPGRADEONBOOT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

