/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.emr.EmrClient;
import software.amazon.awssdk.services.emr.model.ClusterSummary;
import software.amazon.awssdk.services.emr.model.ListClustersRequest;
import software.amazon.awssdk.services.emr.model.ListClustersResponse;

public class ListClustersIterable
implements SdkIterable<ListClustersResponse> {
    private final EmrClient client;
    private final ListClustersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListClustersIterable(EmrClient client, ListClustersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListClustersResponseFetcher();
    }

    public Iterator<ListClustersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ClusterSummary> clusters() {
        Function<ListClustersResponse, Iterator> getIterator = response -> {
            if (response != null && response.clusters() != null) {
                return response.clusters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListClustersIterable resume(ListClustersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListClustersIterable(this.client, (ListClustersRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListClustersIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListClustersResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListClustersResponseFetcher
    implements SyncPageFetcher<ListClustersResponse> {
        private ListClustersResponseFetcher() {
        }

        public boolean hasNextPage(ListClustersResponse previousPage) {
            return previousPage.marker() != null && !SdkAutoConstructList.class.isInstance(previousPage.marker()) && !SdkAutoConstructMap.class.isInstance(previousPage.marker());
        }

        public ListClustersResponse nextPage(ListClustersResponse previousPage) {
            if (previousPage == null) {
                return ListClustersIterable.this.client.listClusters(ListClustersIterable.this.firstRequest);
            }
            return ListClustersIterable.this.client.listClusters((ListClustersRequest)((Object)ListClustersIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

