/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.emr.EmrAsyncClient;
import software.amazon.awssdk.services.emr.model.Command;
import software.amazon.awssdk.services.emr.model.ListBootstrapActionsRequest;
import software.amazon.awssdk.services.emr.model.ListBootstrapActionsResponse;

public class ListBootstrapActionsPublisher
implements SdkPublisher<ListBootstrapActionsResponse> {
    private final EmrAsyncClient client;
    private final ListBootstrapActionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBootstrapActionsPublisher(EmrAsyncClient client, ListBootstrapActionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBootstrapActionsPublisher(EmrAsyncClient client, ListBootstrapActionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBootstrapActionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBootstrapActionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Command> bootstrapActions() {
        Function<ListBootstrapActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.bootstrapActions() != null) {
                return response.bootstrapActions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBootstrapActionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListBootstrapActionsPublisher resume(ListBootstrapActionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListBootstrapActionsPublisher(this.client, (ListBootstrapActionsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListBootstrapActionsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListBootstrapActionsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListBootstrapActionsResponseFetcher
    implements AsyncPageFetcher<ListBootstrapActionsResponse> {
        private ListBootstrapActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListBootstrapActionsResponse previousPage) {
            return previousPage.marker() != null && !SdkAutoConstructList.class.isInstance(previousPage.marker()) && !SdkAutoConstructMap.class.isInstance(previousPage.marker());
        }

        public CompletableFuture<ListBootstrapActionsResponse> nextPage(ListBootstrapActionsResponse previousPage) {
            if (previousPage == null) {
                return ListBootstrapActionsPublisher.this.client.listBootstrapActions(ListBootstrapActionsPublisher.this.firstRequest);
            }
            return ListBootstrapActionsPublisher.this.client.listBootstrapActions((ListBootstrapActionsRequest)((Object)ListBootstrapActionsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

