/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.SpotProvisioningTimeoutAction;
import software.amazon.awssdk.services.emr.transform.SpotProvisioningSpecificationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpotProvisioningSpecification
implements StructuredPojo,
ToCopyableBuilder<Builder, SpotProvisioningSpecification> {
    private final Integer timeoutDurationMinutes;
    private final String timeoutAction;
    private final Integer blockDurationMinutes;

    private SpotProvisioningSpecification(BuilderImpl builder) {
        this.timeoutDurationMinutes = builder.timeoutDurationMinutes;
        this.timeoutAction = builder.timeoutAction;
        this.blockDurationMinutes = builder.blockDurationMinutes;
    }

    public Integer timeoutDurationMinutes() {
        return this.timeoutDurationMinutes;
    }

    public SpotProvisioningTimeoutAction timeoutAction() {
        return SpotProvisioningTimeoutAction.fromValue(this.timeoutAction);
    }

    public String timeoutActionAsString() {
        return this.timeoutAction;
    }

    public Integer blockDurationMinutes() {
        return this.blockDurationMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutDurationMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockDurationMinutes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotProvisioningSpecification)) {
            return false;
        }
        SpotProvisioningSpecification other = (SpotProvisioningSpecification)obj;
        return Objects.equals(this.timeoutDurationMinutes(), other.timeoutDurationMinutes()) && Objects.equals(this.timeoutActionAsString(), other.timeoutActionAsString()) && Objects.equals(this.blockDurationMinutes(), other.blockDurationMinutes());
    }

    public String toString() {
        return ToString.builder((String)"SpotProvisioningSpecification").add("TimeoutDurationMinutes", (Object)this.timeoutDurationMinutes()).add("TimeoutAction", (Object)this.timeoutActionAsString()).add("BlockDurationMinutes", (Object)this.blockDurationMinutes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TimeoutDurationMinutes": {
                return Optional.ofNullable(clazz.cast(this.timeoutDurationMinutes()));
            }
            case "TimeoutAction": {
                return Optional.ofNullable(clazz.cast(this.timeoutActionAsString()));
            }
            case "BlockDurationMinutes": {
                return Optional.ofNullable(clazz.cast(this.blockDurationMinutes()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SpotProvisioningSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer timeoutDurationMinutes;
        private String timeoutAction;
        private Integer blockDurationMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotProvisioningSpecification model) {
            this.timeoutDurationMinutes(model.timeoutDurationMinutes);
            this.timeoutAction(model.timeoutAction);
            this.blockDurationMinutes(model.blockDurationMinutes);
        }

        public final Integer getTimeoutDurationMinutes() {
            return this.timeoutDurationMinutes;
        }

        @Override
        public final Builder timeoutDurationMinutes(Integer timeoutDurationMinutes) {
            this.timeoutDurationMinutes = timeoutDurationMinutes;
            return this;
        }

        public final void setTimeoutDurationMinutes(Integer timeoutDurationMinutes) {
            this.timeoutDurationMinutes = timeoutDurationMinutes;
        }

        public final String getTimeoutAction() {
            return this.timeoutAction;
        }

        @Override
        public final Builder timeoutAction(String timeoutAction) {
            this.timeoutAction = timeoutAction;
            return this;
        }

        @Override
        public final Builder timeoutAction(SpotProvisioningTimeoutAction timeoutAction) {
            this.timeoutAction(timeoutAction.toString());
            return this;
        }

        public final void setTimeoutAction(String timeoutAction) {
            this.timeoutAction = timeoutAction;
        }

        public final Integer getBlockDurationMinutes() {
            return this.blockDurationMinutes;
        }

        @Override
        public final Builder blockDurationMinutes(Integer blockDurationMinutes) {
            this.blockDurationMinutes = blockDurationMinutes;
            return this;
        }

        public final void setBlockDurationMinutes(Integer blockDurationMinutes) {
            this.blockDurationMinutes = blockDurationMinutes;
        }

        public SpotProvisioningSpecification build() {
            return new SpotProvisioningSpecification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SpotProvisioningSpecification> {
        public Builder timeoutDurationMinutes(Integer var1);

        public Builder timeoutAction(String var1);

        public Builder timeoutAction(SpotProvisioningTimeoutAction var1);

        public Builder blockDurationMinutes(Integer var1);
    }
}

