/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.EmrRequest;
import software.amazon.awssdk.services.emr.model.XmlStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetTerminationProtectionRequest
extends EmrRequest
implements ToCopyableBuilder<Builder, SetTerminationProtectionRequest> {
    private final List<String> jobFlowIds;
    private final Boolean terminationProtected;

    private SetTerminationProtectionRequest(BuilderImpl builder) {
        super(builder);
        this.jobFlowIds = builder.jobFlowIds;
        this.terminationProtected = builder.terminationProtected;
    }

    public List<String> jobFlowIds() {
        return this.jobFlowIds;
    }

    public Boolean terminationProtected() {
        return this.terminationProtected;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobFlowIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminationProtected());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetTerminationProtectionRequest)) {
            return false;
        }
        SetTerminationProtectionRequest other = (SetTerminationProtectionRequest)((Object)obj);
        return Objects.equals(this.jobFlowIds(), other.jobFlowIds()) && Objects.equals(this.terminationProtected(), other.terminationProtected());
    }

    public String toString() {
        return ToString.builder((String)"SetTerminationProtectionRequest").add("JobFlowIds", this.jobFlowIds()).add("TerminationProtected", (Object)this.terminationProtected()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobFlowIds": {
                return Optional.ofNullable(clazz.cast(this.jobFlowIds()));
            }
            case "TerminationProtected": {
                return Optional.ofNullable(clazz.cast(this.terminationProtected()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EmrRequest.BuilderImpl
    implements Builder {
        private List<String> jobFlowIds = DefaultSdkAutoConstructList.getInstance();
        private Boolean terminationProtected;

        private BuilderImpl() {
        }

        private BuilderImpl(SetTerminationProtectionRequest model) {
            super(model);
            this.jobFlowIds(model.jobFlowIds);
            this.terminationProtected(model.terminationProtected);
        }

        public final Collection<String> getJobFlowIds() {
            return this.jobFlowIds;
        }

        @Override
        public final Builder jobFlowIds(Collection<String> jobFlowIds) {
            this.jobFlowIds = XmlStringListCopier.copy(jobFlowIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobFlowIds(String ... jobFlowIds) {
            this.jobFlowIds(Arrays.asList(jobFlowIds));
            return this;
        }

        public final void setJobFlowIds(Collection<String> jobFlowIds) {
            this.jobFlowIds = XmlStringListCopier.copy(jobFlowIds);
        }

        public final Boolean getTerminationProtected() {
            return this.terminationProtected;
        }

        @Override
        public final Builder terminationProtected(Boolean terminationProtected) {
            this.terminationProtected = terminationProtected;
            return this;
        }

        public final void setTerminationProtected(Boolean terminationProtected) {
            this.terminationProtected = terminationProtected;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetTerminationProtectionRequest build() {
            return new SetTerminationProtectionRequest(this);
        }
    }

    public static interface Builder
    extends EmrRequest.Builder,
    CopyableBuilder<Builder, SetTerminationProtectionRequest> {
        public Builder jobFlowIds(Collection<String> var1);

        public Builder jobFlowIds(String ... var1);

        public Builder terminationProtected(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

