/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.MarketType;
import software.amazon.awssdk.services.emr.model.SimpleScalingPolicyConfiguration;
import software.amazon.awssdk.services.emr.transform.ScalingActionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScalingAction
implements StructuredPojo,
ToCopyableBuilder<Builder, ScalingAction> {
    private final String market;
    private final SimpleScalingPolicyConfiguration simpleScalingPolicyConfiguration;

    private ScalingAction(BuilderImpl builder) {
        this.market = builder.market;
        this.simpleScalingPolicyConfiguration = builder.simpleScalingPolicyConfiguration;
    }

    public MarketType market() {
        return MarketType.fromValue(this.market);
    }

    public String marketAsString() {
        return this.market;
    }

    public SimpleScalingPolicyConfiguration simpleScalingPolicyConfiguration() {
        return this.simpleScalingPolicyConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marketAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.simpleScalingPolicyConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingAction)) {
            return false;
        }
        ScalingAction other = (ScalingAction)obj;
        return Objects.equals(this.marketAsString(), other.marketAsString()) && Objects.equals(this.simpleScalingPolicyConfiguration(), other.simpleScalingPolicyConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"ScalingAction").add("Market", (Object)this.marketAsString()).add("SimpleScalingPolicyConfiguration", (Object)this.simpleScalingPolicyConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Market": {
                return Optional.ofNullable(clazz.cast(this.marketAsString()));
            }
            case "SimpleScalingPolicyConfiguration": {
                return Optional.ofNullable(clazz.cast(this.simpleScalingPolicyConfiguration()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScalingActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String market;
        private SimpleScalingPolicyConfiguration simpleScalingPolicyConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingAction model) {
            this.market(model.market);
            this.simpleScalingPolicyConfiguration(model.simpleScalingPolicyConfiguration);
        }

        public final String getMarket() {
            return this.market;
        }

        @Override
        public final Builder market(String market) {
            this.market = market;
            return this;
        }

        @Override
        public final Builder market(MarketType market) {
            this.market(market.toString());
            return this;
        }

        public final void setMarket(String market) {
            this.market = market;
        }

        public final SimpleScalingPolicyConfiguration.Builder getSimpleScalingPolicyConfiguration() {
            return this.simpleScalingPolicyConfiguration != null ? this.simpleScalingPolicyConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder simpleScalingPolicyConfiguration(SimpleScalingPolicyConfiguration simpleScalingPolicyConfiguration) {
            this.simpleScalingPolicyConfiguration = simpleScalingPolicyConfiguration;
            return this;
        }

        public final void setSimpleScalingPolicyConfiguration(SimpleScalingPolicyConfiguration.BuilderImpl simpleScalingPolicyConfiguration) {
            this.simpleScalingPolicyConfiguration = simpleScalingPolicyConfiguration != null ? simpleScalingPolicyConfiguration.build() : null;
        }

        public ScalingAction build() {
            return new ScalingAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScalingAction> {
        public Builder market(String var1);

        public Builder market(MarketType var1);

        public Builder simpleScalingPolicyConfiguration(SimpleScalingPolicyConfiguration var1);

        default public Builder simpleScalingPolicyConfiguration(Consumer<SimpleScalingPolicyConfiguration.Builder> simpleScalingPolicyConfiguration) {
            return this.simpleScalingPolicyConfiguration((SimpleScalingPolicyConfiguration)((SimpleScalingPolicyConfiguration.Builder)SimpleScalingPolicyConfiguration.builder().applyMutation(simpleScalingPolicyConfiguration)).build());
        }
    }
}

