/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.ClusterSummary;
import software.amazon.awssdk.services.emr.model.ClusterSummaryListCopier;
import software.amazon.awssdk.services.emr.model.EmrResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListClustersResponse
extends EmrResponse
implements ToCopyableBuilder<Builder, ListClustersResponse> {
    private final List<ClusterSummary> clusters;
    private final String marker;

    private ListClustersResponse(BuilderImpl builder) {
        super(builder);
        this.clusters = builder.clusters;
        this.marker = builder.marker;
    }

    public List<ClusterSummary> clusters() {
        return this.clusters;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusters());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClustersResponse)) {
            return false;
        }
        ListClustersResponse other = (ListClustersResponse)((Object)obj);
        return Objects.equals(this.clusters(), other.clusters()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"ListClustersResponse").add("Clusters", this.clusters()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Clusters": {
                return Optional.ofNullable(clazz.cast(this.clusters()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EmrResponse.BuilderImpl
    implements Builder {
        private List<ClusterSummary> clusters = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClustersResponse model) {
            super(model);
            this.clusters(model.clusters);
            this.marker(model.marker);
        }

        public final Collection<ClusterSummary.Builder> getClusters() {
            return this.clusters != null ? (Collection)this.clusters.stream().map(ClusterSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder clusters(Collection<ClusterSummary> clusters) {
            this.clusters = ClusterSummaryListCopier.copy(clusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(ClusterSummary ... clusters) {
            this.clusters(Arrays.asList(clusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(Consumer<ClusterSummary.Builder> ... clusters) {
            this.clusters(Stream.of(clusters).map(c -> (ClusterSummary)((ClusterSummary.Builder)ClusterSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setClusters(Collection<ClusterSummary.BuilderImpl> clusters) {
            this.clusters = ClusterSummaryListCopier.copyFromBuilder(clusters);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListClustersResponse build() {
            return new ListClustersResponse(this);
        }
    }

    public static interface Builder
    extends EmrResponse.Builder,
    CopyableBuilder<Builder, ListClustersResponse> {
        public Builder clusters(Collection<ClusterSummary> var1);

        public Builder clusters(ClusterSummary ... var1);

        public Builder clusters(Consumer<ClusterSummary.Builder> ... var1);

        public Builder marker(String var1);
    }
}

