/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.SupportedProductConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SupportedProductConfigMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<List> ARGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Args").isBinary(false).build();
    private static final SupportedProductConfigMarshaller INSTANCE = new SupportedProductConfigMarshaller();

    private SupportedProductConfigMarshaller() {
    }

    public static SupportedProductConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SupportedProductConfig supportedProductConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)supportedProductConfig, (String)"supportedProductConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)supportedProductConfig.name(), NAME_BINDING);
            protocolMarshaller.marshall(supportedProductConfig.args(), ARGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

