/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.PlacementType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PlacementTypeMarshaller {
    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailabilityZone").isBinary(false).build();
    private static final MarshallingInfo<List> AVAILABILITYZONES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailabilityZones").isBinary(false).build();
    private static final PlacementTypeMarshaller INSTANCE = new PlacementTypeMarshaller();

    private PlacementTypeMarshaller() {
    }

    public static PlacementTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PlacementType placementType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)placementType, (String)"placementType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)placementType.availabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall(placementType.availabilityZones(), AVAILABILITYZONES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

