/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.ListClustersRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListClustersRequestModelMarshaller {
    private static final MarshallingInfo<Instant> CREATEDAFTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAfter").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDBEFORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedBefore").isBinary(false).build();
    private static final MarshallingInfo<List> CLUSTERSTATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterStates").isBinary(false).build();
    private static final MarshallingInfo<String> MARKER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Marker").isBinary(false).build();
    private static final ListClustersRequestModelMarshaller INSTANCE = new ListClustersRequestModelMarshaller();

    private ListClustersRequestModelMarshaller() {
    }

    public static ListClustersRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListClustersRequest listClustersRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listClustersRequest), (String)"listClustersRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)listClustersRequest.createdAfter(), CREATEDAFTER_BINDING);
            protocolMarshaller.marshall((Object)listClustersRequest.createdBefore(), CREATEDBEFORE_BINDING);
            protocolMarshaller.marshall(listClustersRequest.clusterStatesAsStrings(), CLUSTERSTATES_BINDING);
            protocolMarshaller.marshall((Object)listClustersRequest.marker(), MARKER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

