/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.emr.EMRClient;
import software.amazon.awssdk.services.emr.model.ListStepsRequest;
import software.amazon.awssdk.services.emr.model.ListStepsResponse;
import software.amazon.awssdk.services.emr.model.StepSummary;

public class ListStepsIterable
implements SdkIterable<ListStepsResponse> {
    private final EMRClient client;
    private final ListStepsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStepsIterable(EMRClient client, ListStepsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStepsResponseFetcher();
    }

    public Iterator<ListStepsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<StepSummary> steps() {
        Function<ListStepsResponse, Iterator> getIterator = response -> {
            if (response != null && response.steps() != null) {
                return response.steps().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListStepsIterable resume(ListStepsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListStepsIterable(this.client, (ListStepsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListStepsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListStepsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListStepsResponseFetcher
    implements SyncPageFetcher<ListStepsResponse> {
        private ListStepsResponseFetcher() {
        }

        public boolean hasNextPage(ListStepsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public ListStepsResponse nextPage(ListStepsResponse previousPage) {
            if (previousPage == null) {
                return ListStepsIterable.this.client.listSteps(ListStepsIterable.this.firstRequest);
            }
            return ListStepsIterable.this.client.listSteps((ListStepsRequest)((Object)ListStepsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

