/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.XmlStringListCopier;
import software.amazon.awssdk.services.emr.transform.SupportedProductConfigMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SupportedProductConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, SupportedProductConfig> {
    private final String name;
    private final List<String> args;

    private SupportedProductConfig(BuilderImpl builder) {
        this.name = builder.name;
        this.args = builder.args;
    }

    public String name() {
        return this.name;
    }

    public List<String> args() {
        return this.args;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.args());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SupportedProductConfig)) {
            return false;
        }
        SupportedProductConfig other = (SupportedProductConfig)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.args(), other.args());
    }

    public String toString() {
        return ToString.builder((String)"SupportedProductConfig").add("Name", (Object)this.name()).add("Args", this.args()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Args": {
                return Optional.of(clazz.cast(this.args()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SupportedProductConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> args;

        private BuilderImpl() {
        }

        private BuilderImpl(SupportedProductConfig model) {
            this.name(model.name);
            this.args(model.args);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getArgs() {
            return this.args;
        }

        @Override
        public final Builder args(Collection<String> args) {
            this.args = XmlStringListCopier.copy(args);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder args(String ... args) {
            this.args(Arrays.asList(args));
            return this;
        }

        public final void setArgs(Collection<String> args) {
            this.args = XmlStringListCopier.copy(args);
        }

        public SupportedProductConfig build() {
            return new SupportedProductConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SupportedProductConfig> {
        public Builder name(String var1);

        public Builder args(Collection<String> var1);

        public Builder args(String ... var1);
    }
}

