/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.emr.model.EMRRequest;
import software.amazon.awssdk.services.emr.model.StepState;
import software.amazon.awssdk.services.emr.model.StepStateListCopier;
import software.amazon.awssdk.services.emr.model.XmlStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListStepsRequest
extends EMRRequest
implements ToCopyableBuilder<Builder, ListStepsRequest> {
    private final String clusterId;
    private final List<String> stepStates;
    private final List<String> stepIds;
    private final String marker;

    private ListStepsRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.stepStates = builder.stepStates;
        this.stepIds = builder.stepIds;
        this.marker = builder.marker;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public List<StepState> stepStates() {
        return TypeConverter.convert(this.stepStates, StepState::fromValue);
    }

    public List<String> stepStatesAsStrings() {
        return this.stepStates;
    }

    public List<String> stepIds() {
        return this.stepIds;
    }

    public String marker() {
        return this.marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepStatesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStepsRequest)) {
            return false;
        }
        ListStepsRequest other = (ListStepsRequest)((Object)obj);
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.stepStatesAsStrings(), other.stepStatesAsStrings()) && Objects.equals(this.stepIds(), other.stepIds()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"ListStepsRequest").add("ClusterId", (Object)this.clusterId()).add("StepStates", this.stepStatesAsStrings()).add("StepIds", this.stepIds()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.of(clazz.cast(this.clusterId()));
            }
            case "StepStates": {
                return Optional.of(clazz.cast(this.stepStatesAsStrings()));
            }
            case "StepIds": {
                return Optional.of(clazz.cast(this.stepIds()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EMRRequest.BuilderImpl
    implements Builder {
        private String clusterId;
        private List<String> stepStates;
        private List<String> stepIds;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStepsRequest model) {
            super(model);
            this.clusterId(model.clusterId);
            this.stepStates(model.stepStates);
            this.stepIds(model.stepIds);
            this.marker(model.marker);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final Collection<String> getStepStates() {
            return this.stepStates;
        }

        @Override
        public final Builder stepStates(Collection<String> stepStates) {
            this.stepStates = StepStateListCopier.copy(stepStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepStates(String ... stepStates) {
            this.stepStates(Arrays.asList(stepStates));
            return this;
        }

        public final void setStepStates(Collection<String> stepStates) {
            this.stepStates = StepStateListCopier.copy(stepStates);
        }

        public final Collection<String> getStepIds() {
            return this.stepIds;
        }

        @Override
        public final Builder stepIds(Collection<String> stepIds) {
            this.stepIds = XmlStringListCopier.copy(stepIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepIds(String ... stepIds) {
            this.stepIds(Arrays.asList(stepIds));
            return this;
        }

        public final void setStepIds(Collection<String> stepIds) {
            this.stepIds = XmlStringListCopier.copy(stepIds);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListStepsRequest build() {
            return new ListStepsRequest(this);
        }
    }

    public static interface Builder
    extends EMRRequest.Builder,
    CopyableBuilder<Builder, ListStepsRequest> {
        public Builder clusterId(String var1);

        public Builder stepStates(Collection<String> var1);

        public Builder stepStates(String ... var1);

        public Builder stepIds(Collection<String> var1);

        public Builder stepIds(String ... var1);

        public Builder marker(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

