/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.emr.model.EMRResponse;
import software.amazon.awssdk.services.emr.model.JobFlowDetail;
import software.amazon.awssdk.services.emr.model.JobFlowDetailListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeJobFlowsResponse
extends EMRResponse
implements ToCopyableBuilder<Builder, DescribeJobFlowsResponse> {
    private final List<JobFlowDetail> jobFlows;

    private DescribeJobFlowsResponse(BuilderImpl builder) {
        super(builder);
        this.jobFlows = builder.jobFlows;
    }

    public List<JobFlowDetail> jobFlows() {
        return this.jobFlows;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobFlows());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobFlowsResponse)) {
            return false;
        }
        DescribeJobFlowsResponse other = (DescribeJobFlowsResponse)((Object)obj);
        return Objects.equals(this.jobFlows(), other.jobFlows());
    }

    public String toString() {
        return ToString.builder((String)"DescribeJobFlowsResponse").add("JobFlows", this.jobFlows()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobFlows": {
                return Optional.of(clazz.cast(this.jobFlows()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EMRResponse.BuilderImpl
    implements Builder {
        private List<JobFlowDetail> jobFlows;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobFlowsResponse model) {
            super(model);
            this.jobFlows(model.jobFlows);
        }

        public final Collection<JobFlowDetail.Builder> getJobFlows() {
            return this.jobFlows != null ? (Collection)this.jobFlows.stream().map(JobFlowDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobFlows(Collection<JobFlowDetail> jobFlows) {
            this.jobFlows = JobFlowDetailListCopier.copy(jobFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobFlows(JobFlowDetail ... jobFlows) {
            this.jobFlows(Arrays.asList(jobFlows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobFlows(Consumer<JobFlowDetail.Builder> ... jobFlows) {
            this.jobFlows(Stream.of(jobFlows).map(c -> (JobFlowDetail)((JobFlowDetail.Builder)JobFlowDetail.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJobFlows(Collection<JobFlowDetail.BuilderImpl> jobFlows) {
            this.jobFlows = JobFlowDetailListCopier.copyFromBuilder(jobFlows);
        }

        @Override
        public DescribeJobFlowsResponse build() {
            return new DescribeJobFlowsResponse(this);
        }
    }

    public static interface Builder
    extends EMRResponse.Builder,
    CopyableBuilder<Builder, DescribeJobFlowsResponse> {
        public Builder jobFlows(Collection<JobFlowDetail> var1);

        public Builder jobFlows(JobFlowDetail ... var1);

        public Builder jobFlows(Consumer<JobFlowDetail.Builder> ... var1);
    }
}

