/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.ComparisonOperator;
import software.amazon.awssdk.services.emr.model.MetricDimension;
import software.amazon.awssdk.services.emr.model.MetricDimensionListCopier;
import software.amazon.awssdk.services.emr.model.Statistic;
import software.amazon.awssdk.services.emr.model.Unit;
import software.amazon.awssdk.services.emr.transform.CloudWatchAlarmDefinitionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CloudWatchAlarmDefinition
implements StructuredPojo,
ToCopyableBuilder<Builder, CloudWatchAlarmDefinition> {
    private final String comparisonOperator;
    private final Integer evaluationPeriods;
    private final String metricName;
    private final String namespace;
    private final Integer period;
    private final String statistic;
    private final Double threshold;
    private final String unit;
    private final List<MetricDimension> dimensions;

    private CloudWatchAlarmDefinition(BuilderImpl builder) {
        this.comparisonOperator = builder.comparisonOperator;
        this.evaluationPeriods = builder.evaluationPeriods;
        this.metricName = builder.metricName;
        this.namespace = builder.namespace;
        this.period = builder.period;
        this.statistic = builder.statistic;
        this.threshold = builder.threshold;
        this.unit = builder.unit;
        this.dimensions = builder.dimensions;
    }

    public ComparisonOperator comparisonOperator() {
        return ComparisonOperator.fromValue(this.comparisonOperator);
    }

    public String comparisonOperatorAsString() {
        return this.comparisonOperator;
    }

    public Integer evaluationPeriods() {
        return this.evaluationPeriods;
    }

    public String metricName() {
        return this.metricName;
    }

    public String namespace() {
        return this.namespace;
    }

    public Integer period() {
        return this.period;
    }

    public Statistic statistic() {
        return Statistic.fromValue(this.statistic);
    }

    public String statisticAsString() {
        return this.statistic;
    }

    public Double threshold() {
        return this.threshold;
    }

    public Unit unit() {
        return Unit.fromValue(this.unit);
    }

    public String unitAsString() {
        return this.unit;
    }

    public List<MetricDimension> dimensions() {
        return this.dimensions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationPeriods());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.period());
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.threshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchAlarmDefinition)) {
            return false;
        }
        CloudWatchAlarmDefinition other = (CloudWatchAlarmDefinition)obj;
        return Objects.equals(this.comparisonOperatorAsString(), other.comparisonOperatorAsString()) && Objects.equals(this.evaluationPeriods(), other.evaluationPeriods()) && Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.period(), other.period()) && Objects.equals(this.statisticAsString(), other.statisticAsString()) && Objects.equals(this.threshold(), other.threshold()) && Objects.equals(this.unitAsString(), other.unitAsString()) && Objects.equals(this.dimensions(), other.dimensions());
    }

    public String toString() {
        return ToString.builder((String)"CloudWatchAlarmDefinition").add("ComparisonOperator", (Object)this.comparisonOperatorAsString()).add("EvaluationPeriods", (Object)this.evaluationPeriods()).add("MetricName", (Object)this.metricName()).add("Namespace", (Object)this.namespace()).add("Period", (Object)this.period()).add("Statistic", (Object)this.statisticAsString()).add("Threshold", (Object)this.threshold()).add("Unit", (Object)this.unitAsString()).add("Dimensions", this.dimensions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComparisonOperator": {
                return Optional.of(clazz.cast(this.comparisonOperatorAsString()));
            }
            case "EvaluationPeriods": {
                return Optional.of(clazz.cast(this.evaluationPeriods()));
            }
            case "MetricName": {
                return Optional.of(clazz.cast(this.metricName()));
            }
            case "Namespace": {
                return Optional.of(clazz.cast(this.namespace()));
            }
            case "Period": {
                return Optional.of(clazz.cast(this.period()));
            }
            case "Statistic": {
                return Optional.of(clazz.cast(this.statisticAsString()));
            }
            case "Threshold": {
                return Optional.of(clazz.cast(this.threshold()));
            }
            case "Unit": {
                return Optional.of(clazz.cast(this.unitAsString()));
            }
            case "Dimensions": {
                return Optional.of(clazz.cast(this.dimensions()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CloudWatchAlarmDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String comparisonOperator;
        private Integer evaluationPeriods;
        private String metricName;
        private String namespace;
        private Integer period;
        private String statistic;
        private Double threshold;
        private String unit;
        private List<MetricDimension> dimensions;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchAlarmDefinition model) {
            this.comparisonOperator(model.comparisonOperator);
            this.evaluationPeriods(model.evaluationPeriods);
            this.metricName(model.metricName);
            this.namespace(model.namespace);
            this.period(model.period);
            this.statistic(model.statistic);
            this.threshold(model.threshold);
            this.unit(model.unit);
            this.dimensions(model.dimensions);
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final Integer getEvaluationPeriods() {
            return this.evaluationPeriods;
        }

        @Override
        public final Builder evaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        public final void setEvaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final Integer getPeriod() {
            return this.period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        public final String getStatistic() {
            return this.statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(Statistic statistic) {
            this.statistic(statistic.toString());
            return this;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        public final Double getThreshold() {
            return this.threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(Unit unit) {
            this.unit(unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final Collection<MetricDimension.Builder> getDimensions() {
            return this.dimensions != null ? (Collection)this.dimensions.stream().map(MetricDimension::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dimensions(Collection<MetricDimension> dimensions) {
            this.dimensions = MetricDimensionListCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(MetricDimension ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<MetricDimension.Builder> ... dimensions) {
            this.dimensions(Stream.of(dimensions).map(c -> (MetricDimension)((MetricDimension.Builder)MetricDimension.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDimensions(Collection<MetricDimension.BuilderImpl> dimensions) {
            this.dimensions = MetricDimensionListCopier.copyFromBuilder(dimensions);
        }

        public CloudWatchAlarmDefinition build() {
            return new CloudWatchAlarmDefinition(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CloudWatchAlarmDefinition> {
        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ComparisonOperator var1);

        public Builder evaluationPeriods(Integer var1);

        public Builder metricName(String var1);

        public Builder namespace(String var1);

        public Builder period(Integer var1);

        public Builder statistic(String var1);

        public Builder statistic(Statistic var1);

        public Builder threshold(Double var1);

        public Builder unit(String var1);

        public Builder unit(Unit var1);

        public Builder dimensions(Collection<MetricDimension> var1);

        public Builder dimensions(MetricDimension ... var1);

        public Builder dimensions(Consumer<MetricDimension.Builder> ... var1);
    }
}

