/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.InstanceTypeConfig;

@SdkInternalApi
public class InstanceTypeConfigMarshaller {
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").build();
    private static final MarshallingInfo<Integer> WEIGHTEDCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WeightedCapacity").build();
    private static final MarshallingInfo<String> BIDPRICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BidPrice").build();
    private static final MarshallingInfo<Double> BIDPRICEASPERCENTAGEOFONDEMANDPRICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BidPriceAsPercentageOfOnDemandPrice").build();
    private static final MarshallingInfo<StructuredPojo> EBSCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EbsConfiguration").build();
    private static final MarshallingInfo<List> CONFIGURATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Configurations").build();
    private static final InstanceTypeConfigMarshaller instance = new InstanceTypeConfigMarshaller();

    public static InstanceTypeConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(InstanceTypeConfig instanceTypeConfig, ProtocolMarshaller protocolMarshaller) {
        if (instanceTypeConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)instanceTypeConfig.instanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)instanceTypeConfig.weightedCapacity(), WEIGHTEDCAPACITY_BINDING);
            protocolMarshaller.marshall((Object)instanceTypeConfig.bidPrice(), BIDPRICE_BINDING);
            protocolMarshaller.marshall((Object)instanceTypeConfig.bidPriceAsPercentageOfOnDemandPrice(), BIDPRICEASPERCENTAGEOFONDEMANDPRICE_BINDING);
            protocolMarshaller.marshall((Object)instanceTypeConfig.ebsConfiguration(), EBSCONFIGURATION_BINDING);
            protocolMarshaller.marshall(instanceTypeConfig.configurations(), CONFIGURATIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

