/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.emr.model.InstanceGroup;
import software.amazon.awssdk.services.emr.transform.AutoScalingPolicyDescriptionUnmarshaller;
import software.amazon.awssdk.services.emr.transform.ConfigurationUnmarshaller;
import software.amazon.awssdk.services.emr.transform.EbsBlockDeviceUnmarshaller;
import software.amazon.awssdk.services.emr.transform.InstanceGroupStatusUnmarshaller;
import software.amazon.awssdk.services.emr.transform.ShrinkPolicyUnmarshaller;

public class InstanceGroupUnmarshaller
implements Unmarshaller<InstanceGroup, JsonUnmarshallerContext> {
    private static InstanceGroupUnmarshaller INSTANCE;

    public InstanceGroup unmarshall(JsonUnmarshallerContext context) throws Exception {
        InstanceGroup.Builder instanceGroupBuilder = InstanceGroup.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Id", targetDepth)) {
                    context.nextToken();
                    instanceGroupBuilder.id((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    instanceGroupBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Market", targetDepth)) {
                    context.nextToken();
                    instanceGroupBuilder.market((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("InstanceGroupType", targetDepth)) {
                    context.nextToken();
                    instanceGroupBuilder.instanceGroupType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("BidPrice", targetDepth)) {
                    context.nextToken();
                    instanceGroupBuilder.bidPrice((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("InstanceType", targetDepth)) {
                    context.nextToken();
                    instanceGroupBuilder.instanceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RequestedInstanceCount", targetDepth)) {
                    context.nextToken();
                    instanceGroupBuilder.requestedInstanceCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("RunningInstanceCount", targetDepth)) {
                    context.nextToken();
                    instanceGroupBuilder.runningInstanceCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    instanceGroupBuilder.status(InstanceGroupStatusUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Configurations", targetDepth)) {
                    context.nextToken();
                    instanceGroupBuilder.configurations(new ListUnmarshaller((Unmarshaller)ConfigurationUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("EbsBlockDevices", targetDepth)) {
                    context.nextToken();
                    instanceGroupBuilder.ebsBlockDevices(new ListUnmarshaller((Unmarshaller)EbsBlockDeviceUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("EbsOptimized", targetDepth)) {
                    context.nextToken();
                    instanceGroupBuilder.ebsOptimized((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("ShrinkPolicy", targetDepth)) {
                    context.nextToken();
                    instanceGroupBuilder.shrinkPolicy(ShrinkPolicyUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("AutoScalingPolicy", targetDepth)) {
                    context.nextToken();
                    instanceGroupBuilder.autoScalingPolicy(AutoScalingPolicyDescriptionUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (InstanceGroup)instanceGroupBuilder.build();
    }

    public static InstanceGroupUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InstanceGroupUnmarshaller();
        }
        return INSTANCE;
    }
}

