/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.emr.transform.StepTimelineMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StepTimeline
implements StructuredPojo,
ToCopyableBuilder<Builder, StepTimeline> {
    private final Date creationDateTime;
    private final Date startDateTime;
    private final Date endDateTime;

    private StepTimeline(BuilderImpl builder) {
        this.creationDateTime = builder.creationDateTime;
        this.startDateTime = builder.startDateTime;
        this.endDateTime = builder.endDateTime;
    }

    public Date creationDateTime() {
        return this.creationDateTime;
    }

    public Date startDateTime() {
        return this.startDateTime;
    }

    public Date endDateTime() {
        return this.endDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.creationDateTime() == null ? 0 : this.creationDateTime().hashCode());
        hashCode = 31 * hashCode + (this.startDateTime() == null ? 0 : this.startDateTime().hashCode());
        hashCode = 31 * hashCode + (this.endDateTime() == null ? 0 : this.endDateTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepTimeline)) {
            return false;
        }
        StepTimeline other = (StepTimeline)obj;
        if (other.creationDateTime() == null ^ this.creationDateTime() == null) {
            return false;
        }
        if (other.creationDateTime() != null && !other.creationDateTime().equals(this.creationDateTime())) {
            return false;
        }
        if (other.startDateTime() == null ^ this.startDateTime() == null) {
            return false;
        }
        if (other.startDateTime() != null && !other.startDateTime().equals(this.startDateTime())) {
            return false;
        }
        if (other.endDateTime() == null ^ this.endDateTime() == null) {
            return false;
        }
        return other.endDateTime() == null || other.endDateTime().equals(this.endDateTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.creationDateTime() != null) {
            sb.append("CreationDateTime: ").append(this.creationDateTime()).append(",");
        }
        if (this.startDateTime() != null) {
            sb.append("StartDateTime: ").append(this.startDateTime()).append(",");
        }
        if (this.endDateTime() != null) {
            sb.append("EndDateTime: ").append(this.endDateTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StepTimelineMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Date creationDateTime;
        private Date startDateTime;
        private Date endDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StepTimeline model) {
            this.setCreationDateTime(model.creationDateTime);
            this.setStartDateTime(model.startDateTime);
            this.setEndDateTime(model.endDateTime);
        }

        public final Date getCreationDateTime() {
            return this.creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Date creationDateTime) {
            this.creationDateTime = StandardMemberCopier.copy((Date)creationDateTime);
            return this;
        }

        public final void setCreationDateTime(Date creationDateTime) {
            this.creationDateTime = StandardMemberCopier.copy((Date)creationDateTime);
        }

        public final Date getStartDateTime() {
            return this.startDateTime;
        }

        @Override
        public final Builder startDateTime(Date startDateTime) {
            this.startDateTime = StandardMemberCopier.copy((Date)startDateTime);
            return this;
        }

        public final void setStartDateTime(Date startDateTime) {
            this.startDateTime = StandardMemberCopier.copy((Date)startDateTime);
        }

        public final Date getEndDateTime() {
            return this.endDateTime;
        }

        @Override
        public final Builder endDateTime(Date endDateTime) {
            this.endDateTime = StandardMemberCopier.copy((Date)endDateTime);
            return this;
        }

        public final void setEndDateTime(Date endDateTime) {
            this.endDateTime = StandardMemberCopier.copy((Date)endDateTime);
        }

        public StepTimeline build() {
            return new StepTimeline(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StepTimeline> {
        public Builder creationDateTime(Date var1);

        public Builder startDateTime(Date var1);

        public Builder endDateTime(Date var1);
    }
}

