/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.AdjustmentType;
import software.amazon.awssdk.services.emr.transform.SimpleScalingPolicyConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SimpleScalingPolicyConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, SimpleScalingPolicyConfiguration> {
    private final String adjustmentType;
    private final Integer scalingAdjustment;
    private final Integer coolDown;

    private SimpleScalingPolicyConfiguration(BuilderImpl builder) {
        this.adjustmentType = builder.adjustmentType;
        this.scalingAdjustment = builder.scalingAdjustment;
        this.coolDown = builder.coolDown;
    }

    public String adjustmentType() {
        return this.adjustmentType;
    }

    public Integer scalingAdjustment() {
        return this.scalingAdjustment;
    }

    public Integer coolDown() {
        return this.coolDown;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.adjustmentType() == null ? 0 : this.adjustmentType().hashCode());
        hashCode = 31 * hashCode + (this.scalingAdjustment() == null ? 0 : this.scalingAdjustment().hashCode());
        hashCode = 31 * hashCode + (this.coolDown() == null ? 0 : this.coolDown().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimpleScalingPolicyConfiguration)) {
            return false;
        }
        SimpleScalingPolicyConfiguration other = (SimpleScalingPolicyConfiguration)obj;
        if (other.adjustmentType() == null ^ this.adjustmentType() == null) {
            return false;
        }
        if (other.adjustmentType() != null && !other.adjustmentType().equals(this.adjustmentType())) {
            return false;
        }
        if (other.scalingAdjustment() == null ^ this.scalingAdjustment() == null) {
            return false;
        }
        if (other.scalingAdjustment() != null && !other.scalingAdjustment().equals(this.scalingAdjustment())) {
            return false;
        }
        if (other.coolDown() == null ^ this.coolDown() == null) {
            return false;
        }
        return other.coolDown() == null || other.coolDown().equals(this.coolDown());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.adjustmentType() != null) {
            sb.append("AdjustmentType: ").append(this.adjustmentType()).append(",");
        }
        if (this.scalingAdjustment() != null) {
            sb.append("ScalingAdjustment: ").append(this.scalingAdjustment()).append(",");
        }
        if (this.coolDown() != null) {
            sb.append("CoolDown: ").append(this.coolDown()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SimpleScalingPolicyConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String adjustmentType;
        private Integer scalingAdjustment;
        private Integer coolDown;

        private BuilderImpl() {
        }

        private BuilderImpl(SimpleScalingPolicyConfiguration model) {
            this.setAdjustmentType(model.adjustmentType);
            this.setScalingAdjustment(model.scalingAdjustment);
            this.setCoolDown(model.coolDown);
        }

        public final String getAdjustmentType() {
            return this.adjustmentType;
        }

        @Override
        public final Builder adjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
            return this;
        }

        @Override
        public final Builder adjustmentType(AdjustmentType adjustmentType) {
            this.adjustmentType(adjustmentType.toString());
            return this;
        }

        public final void setAdjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
        }

        public final void setAdjustmentType(AdjustmentType adjustmentType) {
            this.adjustmentType(adjustmentType.toString());
        }

        public final Integer getScalingAdjustment() {
            return this.scalingAdjustment;
        }

        @Override
        public final Builder scalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
            return this;
        }

        public final void setScalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
        }

        public final Integer getCoolDown() {
            return this.coolDown;
        }

        @Override
        public final Builder coolDown(Integer coolDown) {
            this.coolDown = coolDown;
            return this;
        }

        public final void setCoolDown(Integer coolDown) {
            this.coolDown = coolDown;
        }

        public SimpleScalingPolicyConfiguration build() {
            return new SimpleScalingPolicyConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SimpleScalingPolicyConfiguration> {
        public Builder adjustmentType(String var1);

        public Builder adjustmentType(AdjustmentType var1);

        public Builder scalingAdjustment(Integer var1);

        public Builder coolDown(Integer var1);
    }
}

