/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.emr.transform.SecurityConfigurationSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SecurityConfigurationSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, SecurityConfigurationSummary> {
    private final String name;
    private final Date creationDateTime;

    private SecurityConfigurationSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.creationDateTime = builder.creationDateTime;
    }

    public String name() {
        return this.name;
    }

    public Date creationDateTime() {
        return this.creationDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.creationDateTime() == null ? 0 : this.creationDateTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityConfigurationSummary)) {
            return false;
        }
        SecurityConfigurationSummary other = (SecurityConfigurationSummary)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.creationDateTime() == null ^ this.creationDateTime() == null) {
            return false;
        }
        return other.creationDateTime() == null || other.creationDateTime().equals(this.creationDateTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.creationDateTime() != null) {
            sb.append("CreationDateTime: ").append(this.creationDateTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SecurityConfigurationSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private Date creationDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityConfigurationSummary model) {
            this.setName(model.name);
            this.setCreationDateTime(model.creationDateTime);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Date getCreationDateTime() {
            return this.creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Date creationDateTime) {
            this.creationDateTime = StandardMemberCopier.copy((Date)creationDateTime);
            return this;
        }

        public final void setCreationDateTime(Date creationDateTime) {
            this.creationDateTime = StandardMemberCopier.copy((Date)creationDateTime);
        }

        public SecurityConfigurationSummary build() {
            return new SecurityConfigurationSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SecurityConfigurationSummary> {
        public Builder name(String var1);

        public Builder creationDateTime(Date var1);
    }
}

