/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.emr.model.Application;
import software.amazon.awssdk.services.emr.model.ApplicationListCopier;
import software.amazon.awssdk.services.emr.model.BootstrapActionConfig;
import software.amazon.awssdk.services.emr.model.BootstrapActionConfigListCopier;
import software.amazon.awssdk.services.emr.model.Configuration;
import software.amazon.awssdk.services.emr.model.ConfigurationListCopier;
import software.amazon.awssdk.services.emr.model.JobFlowInstancesConfig;
import software.amazon.awssdk.services.emr.model.NewSupportedProductsListCopier;
import software.amazon.awssdk.services.emr.model.ScaleDownBehavior;
import software.amazon.awssdk.services.emr.model.StepConfig;
import software.amazon.awssdk.services.emr.model.StepConfigListCopier;
import software.amazon.awssdk.services.emr.model.SupportedProductConfig;
import software.amazon.awssdk.services.emr.model.SupportedProductsListCopier;
import software.amazon.awssdk.services.emr.model.Tag;
import software.amazon.awssdk.services.emr.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RunJobFlowRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RunJobFlowRequest> {
    private final String name;
    private final String logUri;
    private final String additionalInfo;
    private final String amiVersion;
    private final String releaseLabel;
    private final JobFlowInstancesConfig instances;
    private final List<StepConfig> steps;
    private final List<BootstrapActionConfig> bootstrapActions;
    private final List<String> supportedProducts;
    private final List<SupportedProductConfig> newSupportedProducts;
    private final List<Application> applications;
    private final List<Configuration> configurations;
    private final Boolean visibleToAllUsers;
    private final String jobFlowRole;
    private final String serviceRole;
    private final List<Tag> tags;
    private final String securityConfiguration;
    private final String autoScalingRole;
    private final String scaleDownBehavior;

    private RunJobFlowRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.logUri = builder.logUri;
        this.additionalInfo = builder.additionalInfo;
        this.amiVersion = builder.amiVersion;
        this.releaseLabel = builder.releaseLabel;
        this.instances = builder.instances;
        this.steps = builder.steps;
        this.bootstrapActions = builder.bootstrapActions;
        this.supportedProducts = builder.supportedProducts;
        this.newSupportedProducts = builder.newSupportedProducts;
        this.applications = builder.applications;
        this.configurations = builder.configurations;
        this.visibleToAllUsers = builder.visibleToAllUsers;
        this.jobFlowRole = builder.jobFlowRole;
        this.serviceRole = builder.serviceRole;
        this.tags = builder.tags;
        this.securityConfiguration = builder.securityConfiguration;
        this.autoScalingRole = builder.autoScalingRole;
        this.scaleDownBehavior = builder.scaleDownBehavior;
    }

    public String name() {
        return this.name;
    }

    public String logUri() {
        return this.logUri;
    }

    public String additionalInfo() {
        return this.additionalInfo;
    }

    public String amiVersion() {
        return this.amiVersion;
    }

    public String releaseLabel() {
        return this.releaseLabel;
    }

    public JobFlowInstancesConfig instances() {
        return this.instances;
    }

    public List<StepConfig> steps() {
        return this.steps;
    }

    public List<BootstrapActionConfig> bootstrapActions() {
        return this.bootstrapActions;
    }

    public List<String> supportedProducts() {
        return this.supportedProducts;
    }

    public List<SupportedProductConfig> newSupportedProducts() {
        return this.newSupportedProducts;
    }

    public List<Application> applications() {
        return this.applications;
    }

    public List<Configuration> configurations() {
        return this.configurations;
    }

    public Boolean visibleToAllUsers() {
        return this.visibleToAllUsers;
    }

    public String jobFlowRole() {
        return this.jobFlowRole;
    }

    public String serviceRole() {
        return this.serviceRole;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String securityConfiguration() {
        return this.securityConfiguration;
    }

    public String autoScalingRole() {
        return this.autoScalingRole;
    }

    public String scaleDownBehavior() {
        return this.scaleDownBehavior;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.logUri() == null ? 0 : this.logUri().hashCode());
        hashCode = 31 * hashCode + (this.additionalInfo() == null ? 0 : this.additionalInfo().hashCode());
        hashCode = 31 * hashCode + (this.amiVersion() == null ? 0 : this.amiVersion().hashCode());
        hashCode = 31 * hashCode + (this.releaseLabel() == null ? 0 : this.releaseLabel().hashCode());
        hashCode = 31 * hashCode + (this.instances() == null ? 0 : this.instances().hashCode());
        hashCode = 31 * hashCode + (this.steps() == null ? 0 : this.steps().hashCode());
        hashCode = 31 * hashCode + (this.bootstrapActions() == null ? 0 : this.bootstrapActions().hashCode());
        hashCode = 31 * hashCode + (this.supportedProducts() == null ? 0 : this.supportedProducts().hashCode());
        hashCode = 31 * hashCode + (this.newSupportedProducts() == null ? 0 : this.newSupportedProducts().hashCode());
        hashCode = 31 * hashCode + (this.applications() == null ? 0 : this.applications().hashCode());
        hashCode = 31 * hashCode + (this.configurations() == null ? 0 : this.configurations().hashCode());
        hashCode = 31 * hashCode + (this.visibleToAllUsers() == null ? 0 : this.visibleToAllUsers().hashCode());
        hashCode = 31 * hashCode + (this.jobFlowRole() == null ? 0 : this.jobFlowRole().hashCode());
        hashCode = 31 * hashCode + (this.serviceRole() == null ? 0 : this.serviceRole().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.securityConfiguration() == null ? 0 : this.securityConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.autoScalingRole() == null ? 0 : this.autoScalingRole().hashCode());
        hashCode = 31 * hashCode + (this.scaleDownBehavior() == null ? 0 : this.scaleDownBehavior().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunJobFlowRequest)) {
            return false;
        }
        RunJobFlowRequest other = (RunJobFlowRequest)((Object)obj);
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.logUri() == null ^ this.logUri() == null) {
            return false;
        }
        if (other.logUri() != null && !other.logUri().equals(this.logUri())) {
            return false;
        }
        if (other.additionalInfo() == null ^ this.additionalInfo() == null) {
            return false;
        }
        if (other.additionalInfo() != null && !other.additionalInfo().equals(this.additionalInfo())) {
            return false;
        }
        if (other.amiVersion() == null ^ this.amiVersion() == null) {
            return false;
        }
        if (other.amiVersion() != null && !other.amiVersion().equals(this.amiVersion())) {
            return false;
        }
        if (other.releaseLabel() == null ^ this.releaseLabel() == null) {
            return false;
        }
        if (other.releaseLabel() != null && !other.releaseLabel().equals(this.releaseLabel())) {
            return false;
        }
        if (other.instances() == null ^ this.instances() == null) {
            return false;
        }
        if (other.instances() != null && !other.instances().equals(this.instances())) {
            return false;
        }
        if (other.steps() == null ^ this.steps() == null) {
            return false;
        }
        if (other.steps() != null && !other.steps().equals(this.steps())) {
            return false;
        }
        if (other.bootstrapActions() == null ^ this.bootstrapActions() == null) {
            return false;
        }
        if (other.bootstrapActions() != null && !other.bootstrapActions().equals(this.bootstrapActions())) {
            return false;
        }
        if (other.supportedProducts() == null ^ this.supportedProducts() == null) {
            return false;
        }
        if (other.supportedProducts() != null && !other.supportedProducts().equals(this.supportedProducts())) {
            return false;
        }
        if (other.newSupportedProducts() == null ^ this.newSupportedProducts() == null) {
            return false;
        }
        if (other.newSupportedProducts() != null && !other.newSupportedProducts().equals(this.newSupportedProducts())) {
            return false;
        }
        if (other.applications() == null ^ this.applications() == null) {
            return false;
        }
        if (other.applications() != null && !other.applications().equals(this.applications())) {
            return false;
        }
        if (other.configurations() == null ^ this.configurations() == null) {
            return false;
        }
        if (other.configurations() != null && !other.configurations().equals(this.configurations())) {
            return false;
        }
        if (other.visibleToAllUsers() == null ^ this.visibleToAllUsers() == null) {
            return false;
        }
        if (other.visibleToAllUsers() != null && !other.visibleToAllUsers().equals(this.visibleToAllUsers())) {
            return false;
        }
        if (other.jobFlowRole() == null ^ this.jobFlowRole() == null) {
            return false;
        }
        if (other.jobFlowRole() != null && !other.jobFlowRole().equals(this.jobFlowRole())) {
            return false;
        }
        if (other.serviceRole() == null ^ this.serviceRole() == null) {
            return false;
        }
        if (other.serviceRole() != null && !other.serviceRole().equals(this.serviceRole())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.securityConfiguration() == null ^ this.securityConfiguration() == null) {
            return false;
        }
        if (other.securityConfiguration() != null && !other.securityConfiguration().equals(this.securityConfiguration())) {
            return false;
        }
        if (other.autoScalingRole() == null ^ this.autoScalingRole() == null) {
            return false;
        }
        if (other.autoScalingRole() != null && !other.autoScalingRole().equals(this.autoScalingRole())) {
            return false;
        }
        if (other.scaleDownBehavior() == null ^ this.scaleDownBehavior() == null) {
            return false;
        }
        return other.scaleDownBehavior() == null || other.scaleDownBehavior().equals(this.scaleDownBehavior());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.logUri() != null) {
            sb.append("LogUri: ").append(this.logUri()).append(",");
        }
        if (this.additionalInfo() != null) {
            sb.append("AdditionalInfo: ").append(this.additionalInfo()).append(",");
        }
        if (this.amiVersion() != null) {
            sb.append("AmiVersion: ").append(this.amiVersion()).append(",");
        }
        if (this.releaseLabel() != null) {
            sb.append("ReleaseLabel: ").append(this.releaseLabel()).append(",");
        }
        if (this.instances() != null) {
            sb.append("Instances: ").append(this.instances()).append(",");
        }
        if (this.steps() != null) {
            sb.append("Steps: ").append(this.steps()).append(",");
        }
        if (this.bootstrapActions() != null) {
            sb.append("BootstrapActions: ").append(this.bootstrapActions()).append(",");
        }
        if (this.supportedProducts() != null) {
            sb.append("SupportedProducts: ").append(this.supportedProducts()).append(",");
        }
        if (this.newSupportedProducts() != null) {
            sb.append("NewSupportedProducts: ").append(this.newSupportedProducts()).append(",");
        }
        if (this.applications() != null) {
            sb.append("Applications: ").append(this.applications()).append(",");
        }
        if (this.configurations() != null) {
            sb.append("Configurations: ").append(this.configurations()).append(",");
        }
        if (this.visibleToAllUsers() != null) {
            sb.append("VisibleToAllUsers: ").append(this.visibleToAllUsers()).append(",");
        }
        if (this.jobFlowRole() != null) {
            sb.append("JobFlowRole: ").append(this.jobFlowRole()).append(",");
        }
        if (this.serviceRole() != null) {
            sb.append("ServiceRole: ").append(this.serviceRole()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.securityConfiguration() != null) {
            sb.append("SecurityConfiguration: ").append(this.securityConfiguration()).append(",");
        }
        if (this.autoScalingRole() != null) {
            sb.append("AutoScalingRole: ").append(this.autoScalingRole()).append(",");
        }
        if (this.scaleDownBehavior() != null) {
            sb.append("ScaleDownBehavior: ").append(this.scaleDownBehavior()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String logUri;
        private String additionalInfo;
        private String amiVersion;
        private String releaseLabel;
        private JobFlowInstancesConfig instances;
        private List<StepConfig> steps = new SdkInternalList();
        private List<BootstrapActionConfig> bootstrapActions = new SdkInternalList();
        private List<String> supportedProducts = new SdkInternalList();
        private List<SupportedProductConfig> newSupportedProducts = new SdkInternalList();
        private List<Application> applications = new SdkInternalList();
        private List<Configuration> configurations = new SdkInternalList();
        private Boolean visibleToAllUsers;
        private String jobFlowRole;
        private String serviceRole;
        private List<Tag> tags = new SdkInternalList();
        private String securityConfiguration;
        private String autoScalingRole;
        private String scaleDownBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(RunJobFlowRequest model) {
            this.setName(model.name);
            this.setLogUri(model.logUri);
            this.setAdditionalInfo(model.additionalInfo);
            this.setAmiVersion(model.amiVersion);
            this.setReleaseLabel(model.releaseLabel);
            this.setInstances(model.instances);
            this.setSteps(model.steps);
            this.setBootstrapActions(model.bootstrapActions);
            this.setSupportedProducts(model.supportedProducts);
            this.setNewSupportedProducts(model.newSupportedProducts);
            this.setApplications(model.applications);
            this.setConfigurations(model.configurations);
            this.setVisibleToAllUsers(model.visibleToAllUsers);
            this.setJobFlowRole(model.jobFlowRole);
            this.setServiceRole(model.serviceRole);
            this.setTags(model.tags);
            this.setSecurityConfiguration(model.securityConfiguration);
            this.setAutoScalingRole(model.autoScalingRole);
            this.setScaleDownBehavior(model.scaleDownBehavior);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getLogUri() {
            return this.logUri;
        }

        @Override
        public final Builder logUri(String logUri) {
            this.logUri = logUri;
            return this;
        }

        public final void setLogUri(String logUri) {
            this.logUri = logUri;
        }

        public final String getAdditionalInfo() {
            return this.additionalInfo;
        }

        @Override
        public final Builder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public final void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        public final String getAmiVersion() {
            return this.amiVersion;
        }

        @Override
        public final Builder amiVersion(String amiVersion) {
            this.amiVersion = amiVersion;
            return this;
        }

        public final void setAmiVersion(String amiVersion) {
            this.amiVersion = amiVersion;
        }

        public final String getReleaseLabel() {
            return this.releaseLabel;
        }

        @Override
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        public final JobFlowInstancesConfig getInstances() {
            return this.instances;
        }

        @Override
        public final Builder instances(JobFlowInstancesConfig instances) {
            this.instances = instances;
            return this;
        }

        public final void setInstances(JobFlowInstancesConfig instances) {
            this.instances = instances;
        }

        public final Collection<StepConfig> getSteps() {
            return this.steps;
        }

        @Override
        public final Builder steps(Collection<StepConfig> steps) {
            this.steps = StepConfigListCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(StepConfig ... steps) {
            if (this.steps == null) {
                this.steps = new SdkInternalList(steps.length);
            }
            for (StepConfig e : steps) {
                this.steps.add(e);
            }
            return this;
        }

        public final void setSteps(Collection<StepConfig> steps) {
            this.steps = StepConfigListCopier.copy(steps);
        }

        @SafeVarargs
        public final void setSteps(StepConfig ... steps) {
            if (this.steps == null) {
                this.steps = new SdkInternalList(steps.length);
            }
            for (StepConfig e : steps) {
                this.steps.add(e);
            }
        }

        public final Collection<BootstrapActionConfig> getBootstrapActions() {
            return this.bootstrapActions;
        }

        @Override
        public final Builder bootstrapActions(Collection<BootstrapActionConfig> bootstrapActions) {
            this.bootstrapActions = BootstrapActionConfigListCopier.copy(bootstrapActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bootstrapActions(BootstrapActionConfig ... bootstrapActions) {
            if (this.bootstrapActions == null) {
                this.bootstrapActions = new SdkInternalList(bootstrapActions.length);
            }
            for (BootstrapActionConfig e : bootstrapActions) {
                this.bootstrapActions.add(e);
            }
            return this;
        }

        public final void setBootstrapActions(Collection<BootstrapActionConfig> bootstrapActions) {
            this.bootstrapActions = BootstrapActionConfigListCopier.copy(bootstrapActions);
        }

        @SafeVarargs
        public final void setBootstrapActions(BootstrapActionConfig ... bootstrapActions) {
            if (this.bootstrapActions == null) {
                this.bootstrapActions = new SdkInternalList(bootstrapActions.length);
            }
            for (BootstrapActionConfig e : bootstrapActions) {
                this.bootstrapActions.add(e);
            }
        }

        public final Collection<String> getSupportedProducts() {
            return this.supportedProducts;
        }

        @Override
        public final Builder supportedProducts(Collection<String> supportedProducts) {
            this.supportedProducts = SupportedProductsListCopier.copy(supportedProducts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedProducts(String ... supportedProducts) {
            if (this.supportedProducts == null) {
                this.supportedProducts = new SdkInternalList(supportedProducts.length);
            }
            for (String e : supportedProducts) {
                this.supportedProducts.add(e);
            }
            return this;
        }

        public final void setSupportedProducts(Collection<String> supportedProducts) {
            this.supportedProducts = SupportedProductsListCopier.copy(supportedProducts);
        }

        @SafeVarargs
        public final void setSupportedProducts(String ... supportedProducts) {
            if (this.supportedProducts == null) {
                this.supportedProducts = new SdkInternalList(supportedProducts.length);
            }
            for (String e : supportedProducts) {
                this.supportedProducts.add(e);
            }
        }

        public final Collection<SupportedProductConfig> getNewSupportedProducts() {
            return this.newSupportedProducts;
        }

        @Override
        public final Builder newSupportedProducts(Collection<SupportedProductConfig> newSupportedProducts) {
            this.newSupportedProducts = NewSupportedProductsListCopier.copy(newSupportedProducts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder newSupportedProducts(SupportedProductConfig ... newSupportedProducts) {
            if (this.newSupportedProducts == null) {
                this.newSupportedProducts = new SdkInternalList(newSupportedProducts.length);
            }
            for (SupportedProductConfig e : newSupportedProducts) {
                this.newSupportedProducts.add(e);
            }
            return this;
        }

        public final void setNewSupportedProducts(Collection<SupportedProductConfig> newSupportedProducts) {
            this.newSupportedProducts = NewSupportedProductsListCopier.copy(newSupportedProducts);
        }

        @SafeVarargs
        public final void setNewSupportedProducts(SupportedProductConfig ... newSupportedProducts) {
            if (this.newSupportedProducts == null) {
                this.newSupportedProducts = new SdkInternalList(newSupportedProducts.length);
            }
            for (SupportedProductConfig e : newSupportedProducts) {
                this.newSupportedProducts.add(e);
            }
        }

        public final Collection<Application> getApplications() {
            return this.applications;
        }

        @Override
        public final Builder applications(Collection<Application> applications) {
            this.applications = ApplicationListCopier.copy(applications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(Application ... applications) {
            if (this.applications == null) {
                this.applications = new SdkInternalList(applications.length);
            }
            for (Application e : applications) {
                this.applications.add(e);
            }
            return this;
        }

        public final void setApplications(Collection<Application> applications) {
            this.applications = ApplicationListCopier.copy(applications);
        }

        @SafeVarargs
        public final void setApplications(Application ... applications) {
            if (this.applications == null) {
                this.applications = new SdkInternalList(applications.length);
            }
            for (Application e : applications) {
                this.applications.add(e);
            }
        }

        public final Collection<Configuration> getConfigurations() {
            return this.configurations;
        }

        @Override
        public final Builder configurations(Collection<Configuration> configurations) {
            this.configurations = ConfigurationListCopier.copy(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Configuration ... configurations) {
            if (this.configurations == null) {
                this.configurations = new SdkInternalList(configurations.length);
            }
            for (Configuration e : configurations) {
                this.configurations.add(e);
            }
            return this;
        }

        public final void setConfigurations(Collection<Configuration> configurations) {
            this.configurations = ConfigurationListCopier.copy(configurations);
        }

        @SafeVarargs
        public final void setConfigurations(Configuration ... configurations) {
            if (this.configurations == null) {
                this.configurations = new SdkInternalList(configurations.length);
            }
            for (Configuration e : configurations) {
                this.configurations.add(e);
            }
        }

        public final Boolean getVisibleToAllUsers() {
            return this.visibleToAllUsers;
        }

        @Override
        public final Builder visibleToAllUsers(Boolean visibleToAllUsers) {
            this.visibleToAllUsers = visibleToAllUsers;
            return this;
        }

        public final void setVisibleToAllUsers(Boolean visibleToAllUsers) {
            this.visibleToAllUsers = visibleToAllUsers;
        }

        public final String getJobFlowRole() {
            return this.jobFlowRole;
        }

        @Override
        public final Builder jobFlowRole(String jobFlowRole) {
            this.jobFlowRole = jobFlowRole;
            return this;
        }

        public final void setJobFlowRole(String jobFlowRole) {
            this.jobFlowRole = jobFlowRole;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
        }

        public final String getSecurityConfiguration() {
            return this.securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        public final String getAutoScalingRole() {
            return this.autoScalingRole;
        }

        @Override
        public final Builder autoScalingRole(String autoScalingRole) {
            this.autoScalingRole = autoScalingRole;
            return this;
        }

        public final void setAutoScalingRole(String autoScalingRole) {
            this.autoScalingRole = autoScalingRole;
        }

        public final String getScaleDownBehavior() {
            return this.scaleDownBehavior;
        }

        @Override
        public final Builder scaleDownBehavior(String scaleDownBehavior) {
            this.scaleDownBehavior = scaleDownBehavior;
            return this;
        }

        @Override
        public final Builder scaleDownBehavior(ScaleDownBehavior scaleDownBehavior) {
            this.scaleDownBehavior(scaleDownBehavior.toString());
            return this;
        }

        public final void setScaleDownBehavior(String scaleDownBehavior) {
            this.scaleDownBehavior = scaleDownBehavior;
        }

        public final void setScaleDownBehavior(ScaleDownBehavior scaleDownBehavior) {
            this.scaleDownBehavior(scaleDownBehavior.toString());
        }

        public RunJobFlowRequest build() {
            return new RunJobFlowRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RunJobFlowRequest> {
        public Builder name(String var1);

        public Builder logUri(String var1);

        public Builder additionalInfo(String var1);

        public Builder amiVersion(String var1);

        public Builder releaseLabel(String var1);

        public Builder instances(JobFlowInstancesConfig var1);

        public Builder steps(Collection<StepConfig> var1);

        public Builder steps(StepConfig ... var1);

        public Builder bootstrapActions(Collection<BootstrapActionConfig> var1);

        public Builder bootstrapActions(BootstrapActionConfig ... var1);

        public Builder supportedProducts(Collection<String> var1);

        public Builder supportedProducts(String ... var1);

        public Builder newSupportedProducts(Collection<SupportedProductConfig> var1);

        public Builder newSupportedProducts(SupportedProductConfig ... var1);

        public Builder applications(Collection<Application> var1);

        public Builder applications(Application ... var1);

        public Builder configurations(Collection<Configuration> var1);

        public Builder configurations(Configuration ... var1);

        public Builder visibleToAllUsers(Boolean var1);

        public Builder jobFlowRole(String var1);

        public Builder serviceRole(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder securityConfiguration(String var1);

        public Builder autoScalingRole(String var1);

        public Builder scaleDownBehavior(String var1);

        public Builder scaleDownBehavior(ScaleDownBehavior var1);
    }
}

