/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.emr.model.StepSummary;
import software.amazon.awssdk.services.emr.model.StepSummaryListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListStepsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListStepsResponse> {
    private final List<StepSummary> steps;
    private final String marker;

    private ListStepsResponse(BuilderImpl builder) {
        this.steps = builder.steps;
        this.marker = builder.marker;
    }

    public List<StepSummary> steps() {
        return this.steps;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.steps() == null ? 0 : this.steps().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStepsResponse)) {
            return false;
        }
        ListStepsResponse other = (ListStepsResponse)((Object)obj);
        if (other.steps() == null ^ this.steps() == null) {
            return false;
        }
        if (other.steps() != null && !other.steps().equals(this.steps())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.steps() != null) {
            sb.append("Steps: ").append(this.steps()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<StepSummary> steps = new SdkInternalList();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStepsResponse model) {
            this.setSteps(model.steps);
            this.setMarker(model.marker);
        }

        public final Collection<StepSummary> getSteps() {
            return this.steps;
        }

        @Override
        public final Builder steps(Collection<StepSummary> steps) {
            this.steps = StepSummaryListCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(StepSummary ... steps) {
            if (this.steps == null) {
                this.steps = new SdkInternalList(steps.length);
            }
            for (StepSummary e : steps) {
                this.steps.add(e);
            }
            return this;
        }

        public final void setSteps(Collection<StepSummary> steps) {
            this.steps = StepSummaryListCopier.copy(steps);
        }

        @SafeVarargs
        public final void setSteps(StepSummary ... steps) {
            if (this.steps == null) {
                this.steps = new SdkInternalList(steps.length);
            }
            for (StepSummary e : steps) {
                this.steps.add(e);
            }
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public ListStepsResponse build() {
            return new ListStepsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListStepsResponse> {
        public Builder steps(Collection<StepSummary> var1);

        public Builder steps(StepSummary ... var1);

        public Builder marker(String var1);
    }
}

