/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.emr.model.InstanceFleetType;
import software.amazon.awssdk.services.emr.model.InstanceGroupType;
import software.amazon.awssdk.services.emr.model.InstanceGroupTypeListCopier;
import software.amazon.awssdk.services.emr.model.InstanceState;
import software.amazon.awssdk.services.emr.model.InstanceStateListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListInstancesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListInstancesRequest> {
    private final String clusterId;
    private final String instanceGroupId;
    private final List<String> instanceGroupTypes;
    private final String instanceFleetId;
    private final String instanceFleetType;
    private final List<String> instanceStates;
    private final String marker;

    private ListInstancesRequest(BuilderImpl builder) {
        this.clusterId = builder.clusterId;
        this.instanceGroupId = builder.instanceGroupId;
        this.instanceGroupTypes = builder.instanceGroupTypes;
        this.instanceFleetId = builder.instanceFleetId;
        this.instanceFleetType = builder.instanceFleetType;
        this.instanceStates = builder.instanceStates;
        this.marker = builder.marker;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public String instanceGroupId() {
        return this.instanceGroupId;
    }

    public List<String> instanceGroupTypes() {
        return this.instanceGroupTypes;
    }

    public String instanceFleetId() {
        return this.instanceFleetId;
    }

    public String instanceFleetType() {
        return this.instanceFleetType;
    }

    public List<String> instanceStates() {
        return this.instanceStates;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clusterId() == null ? 0 : this.clusterId().hashCode());
        hashCode = 31 * hashCode + (this.instanceGroupId() == null ? 0 : this.instanceGroupId().hashCode());
        hashCode = 31 * hashCode + (this.instanceGroupTypes() == null ? 0 : this.instanceGroupTypes().hashCode());
        hashCode = 31 * hashCode + (this.instanceFleetId() == null ? 0 : this.instanceFleetId().hashCode());
        hashCode = 31 * hashCode + (this.instanceFleetType() == null ? 0 : this.instanceFleetType().hashCode());
        hashCode = 31 * hashCode + (this.instanceStates() == null ? 0 : this.instanceStates().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstancesRequest)) {
            return false;
        }
        ListInstancesRequest other = (ListInstancesRequest)((Object)obj);
        if (other.clusterId() == null ^ this.clusterId() == null) {
            return false;
        }
        if (other.clusterId() != null && !other.clusterId().equals(this.clusterId())) {
            return false;
        }
        if (other.instanceGroupId() == null ^ this.instanceGroupId() == null) {
            return false;
        }
        if (other.instanceGroupId() != null && !other.instanceGroupId().equals(this.instanceGroupId())) {
            return false;
        }
        if (other.instanceGroupTypes() == null ^ this.instanceGroupTypes() == null) {
            return false;
        }
        if (other.instanceGroupTypes() != null && !other.instanceGroupTypes().equals(this.instanceGroupTypes())) {
            return false;
        }
        if (other.instanceFleetId() == null ^ this.instanceFleetId() == null) {
            return false;
        }
        if (other.instanceFleetId() != null && !other.instanceFleetId().equals(this.instanceFleetId())) {
            return false;
        }
        if (other.instanceFleetType() == null ^ this.instanceFleetType() == null) {
            return false;
        }
        if (other.instanceFleetType() != null && !other.instanceFleetType().equals(this.instanceFleetType())) {
            return false;
        }
        if (other.instanceStates() == null ^ this.instanceStates() == null) {
            return false;
        }
        if (other.instanceStates() != null && !other.instanceStates().equals(this.instanceStates())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterId() != null) {
            sb.append("ClusterId: ").append(this.clusterId()).append(",");
        }
        if (this.instanceGroupId() != null) {
            sb.append("InstanceGroupId: ").append(this.instanceGroupId()).append(",");
        }
        if (this.instanceGroupTypes() != null) {
            sb.append("InstanceGroupTypes: ").append(this.instanceGroupTypes()).append(",");
        }
        if (this.instanceFleetId() != null) {
            sb.append("InstanceFleetId: ").append(this.instanceFleetId()).append(",");
        }
        if (this.instanceFleetType() != null) {
            sb.append("InstanceFleetType: ").append(this.instanceFleetType()).append(",");
        }
        if (this.instanceStates() != null) {
            sb.append("InstanceStates: ").append(this.instanceStates()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String clusterId;
        private String instanceGroupId;
        private List<String> instanceGroupTypes = new SdkInternalList();
        private String instanceFleetId;
        private String instanceFleetType;
        private List<String> instanceStates = new SdkInternalList();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstancesRequest model) {
            this.setClusterId(model.clusterId);
            this.setInstanceGroupId(model.instanceGroupId);
            this.setInstanceGroupTypes(model.instanceGroupTypes);
            this.setInstanceFleetId(model.instanceFleetId);
            this.setInstanceFleetType(model.instanceFleetType);
            this.setInstanceStates(model.instanceStates);
            this.setMarker(model.marker);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final String getInstanceGroupId() {
            return this.instanceGroupId;
        }

        @Override
        public final Builder instanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
            return this;
        }

        public final void setInstanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
        }

        public final Collection<String> getInstanceGroupTypes() {
            return this.instanceGroupTypes;
        }

        @Override
        public final Builder instanceGroupTypes(Collection<String> instanceGroupTypes) {
            this.instanceGroupTypes = InstanceGroupTypeListCopier.copy(instanceGroupTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroupTypes(String ... instanceGroupTypes) {
            if (this.instanceGroupTypes == null) {
                this.instanceGroupTypes = new SdkInternalList(instanceGroupTypes.length);
            }
            for (String e : instanceGroupTypes) {
                this.instanceGroupTypes.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroupTypes(InstanceGroupType ... instanceGroupTypes) {
            if (this.instanceGroupTypes == null) {
                this.instanceGroupTypes = new SdkInternalList(instanceGroupTypes.length);
            }
            for (InstanceGroupType ele : instanceGroupTypes) {
                this.instanceGroupTypes.add(ele.toString());
            }
            return this;
        }

        public final void setInstanceGroupTypes(Collection<String> instanceGroupTypes) {
            this.instanceGroupTypes = InstanceGroupTypeListCopier.copy(instanceGroupTypes);
        }

        @SafeVarargs
        public final void setInstanceGroupTypes(String ... instanceGroupTypes) {
            if (this.instanceGroupTypes == null) {
                this.instanceGroupTypes = new SdkInternalList(instanceGroupTypes.length);
            }
            for (String e : instanceGroupTypes) {
                this.instanceGroupTypes.add(e);
            }
        }

        @SafeVarargs
        public final void setInstanceGroupTypes(InstanceGroupType ... instanceGroupTypes) {
            if (this.instanceGroupTypes == null) {
                this.instanceGroupTypes = new SdkInternalList(instanceGroupTypes.length);
            }
            for (InstanceGroupType ele : instanceGroupTypes) {
                this.instanceGroupTypes.add(ele.toString());
            }
        }

        public final String getInstanceFleetId() {
            return this.instanceFleetId;
        }

        @Override
        public final Builder instanceFleetId(String instanceFleetId) {
            this.instanceFleetId = instanceFleetId;
            return this;
        }

        public final void setInstanceFleetId(String instanceFleetId) {
            this.instanceFleetId = instanceFleetId;
        }

        public final String getInstanceFleetType() {
            return this.instanceFleetType;
        }

        @Override
        public final Builder instanceFleetType(String instanceFleetType) {
            this.instanceFleetType = instanceFleetType;
            return this;
        }

        @Override
        public final Builder instanceFleetType(InstanceFleetType instanceFleetType) {
            this.instanceFleetType(instanceFleetType.toString());
            return this;
        }

        public final void setInstanceFleetType(String instanceFleetType) {
            this.instanceFleetType = instanceFleetType;
        }

        public final void setInstanceFleetType(InstanceFleetType instanceFleetType) {
            this.instanceFleetType(instanceFleetType.toString());
        }

        public final Collection<String> getInstanceStates() {
            return this.instanceStates;
        }

        @Override
        public final Builder instanceStates(Collection<String> instanceStates) {
            this.instanceStates = InstanceStateListCopier.copy(instanceStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStates(String ... instanceStates) {
            if (this.instanceStates == null) {
                this.instanceStates = new SdkInternalList(instanceStates.length);
            }
            for (String e : instanceStates) {
                this.instanceStates.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStates(InstanceState ... instanceStates) {
            if (this.instanceStates == null) {
                this.instanceStates = new SdkInternalList(instanceStates.length);
            }
            for (InstanceState ele : instanceStates) {
                this.instanceStates.add(ele.toString());
            }
            return this;
        }

        public final void setInstanceStates(Collection<String> instanceStates) {
            this.instanceStates = InstanceStateListCopier.copy(instanceStates);
        }

        @SafeVarargs
        public final void setInstanceStates(String ... instanceStates) {
            if (this.instanceStates == null) {
                this.instanceStates = new SdkInternalList(instanceStates.length);
            }
            for (String e : instanceStates) {
                this.instanceStates.add(e);
            }
        }

        @SafeVarargs
        public final void setInstanceStates(InstanceState ... instanceStates) {
            if (this.instanceStates == null) {
                this.instanceStates = new SdkInternalList(instanceStates.length);
            }
            for (InstanceState ele : instanceStates) {
                this.instanceStates.add(ele.toString());
            }
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public ListInstancesRequest build() {
            return new ListInstancesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListInstancesRequest> {
        public Builder clusterId(String var1);

        public Builder instanceGroupId(String var1);

        public Builder instanceGroupTypes(Collection<String> var1);

        public Builder instanceGroupTypes(String ... var1);

        public Builder instanceGroupTypes(InstanceGroupType ... var1);

        public Builder instanceFleetId(String var1);

        public Builder instanceFleetType(String var1);

        public Builder instanceFleetType(InstanceFleetType var1);

        public Builder instanceStates(Collection<String> var1);

        public Builder instanceStates(String ... var1);

        public Builder instanceStates(InstanceState ... var1);

        public Builder marker(String var1);
    }
}

