/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.emr.transform.InstanceTimelineMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceTimeline
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceTimeline> {
    private final Date creationDateTime;
    private final Date readyDateTime;
    private final Date endDateTime;

    private InstanceTimeline(BuilderImpl builder) {
        this.creationDateTime = builder.creationDateTime;
        this.readyDateTime = builder.readyDateTime;
        this.endDateTime = builder.endDateTime;
    }

    public Date creationDateTime() {
        return this.creationDateTime;
    }

    public Date readyDateTime() {
        return this.readyDateTime;
    }

    public Date endDateTime() {
        return this.endDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.creationDateTime() == null ? 0 : this.creationDateTime().hashCode());
        hashCode = 31 * hashCode + (this.readyDateTime() == null ? 0 : this.readyDateTime().hashCode());
        hashCode = 31 * hashCode + (this.endDateTime() == null ? 0 : this.endDateTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceTimeline)) {
            return false;
        }
        InstanceTimeline other = (InstanceTimeline)obj;
        if (other.creationDateTime() == null ^ this.creationDateTime() == null) {
            return false;
        }
        if (other.creationDateTime() != null && !other.creationDateTime().equals(this.creationDateTime())) {
            return false;
        }
        if (other.readyDateTime() == null ^ this.readyDateTime() == null) {
            return false;
        }
        if (other.readyDateTime() != null && !other.readyDateTime().equals(this.readyDateTime())) {
            return false;
        }
        if (other.endDateTime() == null ^ this.endDateTime() == null) {
            return false;
        }
        return other.endDateTime() == null || other.endDateTime().equals(this.endDateTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.creationDateTime() != null) {
            sb.append("CreationDateTime: ").append(this.creationDateTime()).append(",");
        }
        if (this.readyDateTime() != null) {
            sb.append("ReadyDateTime: ").append(this.readyDateTime()).append(",");
        }
        if (this.endDateTime() != null) {
            sb.append("EndDateTime: ").append(this.endDateTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceTimelineMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Date creationDateTime;
        private Date readyDateTime;
        private Date endDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceTimeline model) {
            this.setCreationDateTime(model.creationDateTime);
            this.setReadyDateTime(model.readyDateTime);
            this.setEndDateTime(model.endDateTime);
        }

        public final Date getCreationDateTime() {
            return this.creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Date creationDateTime) {
            this.creationDateTime = StandardMemberCopier.copy((Date)creationDateTime);
            return this;
        }

        public final void setCreationDateTime(Date creationDateTime) {
            this.creationDateTime = StandardMemberCopier.copy((Date)creationDateTime);
        }

        public final Date getReadyDateTime() {
            return this.readyDateTime;
        }

        @Override
        public final Builder readyDateTime(Date readyDateTime) {
            this.readyDateTime = StandardMemberCopier.copy((Date)readyDateTime);
            return this;
        }

        public final void setReadyDateTime(Date readyDateTime) {
            this.readyDateTime = StandardMemberCopier.copy((Date)readyDateTime);
        }

        public final Date getEndDateTime() {
            return this.endDateTime;
        }

        @Override
        public final Builder endDateTime(Date endDateTime) {
            this.endDateTime = StandardMemberCopier.copy((Date)endDateTime);
            return this;
        }

        public final void setEndDateTime(Date endDateTime) {
            this.endDateTime = StandardMemberCopier.copy((Date)endDateTime);
        }

        public InstanceTimeline build() {
            return new InstanceTimeline(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceTimeline> {
        public Builder creationDateTime(Date var1);

        public Builder readyDateTime(Date var1);

        public Builder endDateTime(Date var1);
    }
}

