/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.VolumeSpecification;
import software.amazon.awssdk.services.emr.transform.EbsBlockDeviceConfigMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EbsBlockDeviceConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, EbsBlockDeviceConfig> {
    private final VolumeSpecification volumeSpecification;
    private final Integer volumesPerInstance;

    private EbsBlockDeviceConfig(BuilderImpl builder) {
        this.volumeSpecification = builder.volumeSpecification;
        this.volumesPerInstance = builder.volumesPerInstance;
    }

    public VolumeSpecification volumeSpecification() {
        return this.volumeSpecification;
    }

    public Integer volumesPerInstance() {
        return this.volumesPerInstance;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.volumeSpecification() == null ? 0 : this.volumeSpecification().hashCode());
        hashCode = 31 * hashCode + (this.volumesPerInstance() == null ? 0 : this.volumesPerInstance().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsBlockDeviceConfig)) {
            return false;
        }
        EbsBlockDeviceConfig other = (EbsBlockDeviceConfig)obj;
        if (other.volumeSpecification() == null ^ this.volumeSpecification() == null) {
            return false;
        }
        if (other.volumeSpecification() != null && !other.volumeSpecification().equals(this.volumeSpecification())) {
            return false;
        }
        if (other.volumesPerInstance() == null ^ this.volumesPerInstance() == null) {
            return false;
        }
        return other.volumesPerInstance() == null || other.volumesPerInstance().equals(this.volumesPerInstance());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.volumeSpecification() != null) {
            sb.append("VolumeSpecification: ").append(this.volumeSpecification()).append(",");
        }
        if (this.volumesPerInstance() != null) {
            sb.append("VolumesPerInstance: ").append(this.volumesPerInstance()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EbsBlockDeviceConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private VolumeSpecification volumeSpecification;
        private Integer volumesPerInstance;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsBlockDeviceConfig model) {
            this.setVolumeSpecification(model.volumeSpecification);
            this.setVolumesPerInstance(model.volumesPerInstance);
        }

        public final VolumeSpecification getVolumeSpecification() {
            return this.volumeSpecification;
        }

        @Override
        public final Builder volumeSpecification(VolumeSpecification volumeSpecification) {
            this.volumeSpecification = volumeSpecification;
            return this;
        }

        public final void setVolumeSpecification(VolumeSpecification volumeSpecification) {
            this.volumeSpecification = volumeSpecification;
        }

        public final Integer getVolumesPerInstance() {
            return this.volumesPerInstance;
        }

        @Override
        public final Builder volumesPerInstance(Integer volumesPerInstance) {
            this.volumesPerInstance = volumesPerInstance;
            return this;
        }

        public final void setVolumesPerInstance(Integer volumesPerInstance) {
            this.volumesPerInstance = volumesPerInstance;
        }

        public EbsBlockDeviceConfig build() {
            return new EbsBlockDeviceConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EbsBlockDeviceConfig> {
        public Builder volumeSpecification(VolumeSpecification var1);

        public Builder volumesPerInstance(Integer var1);
    }
}

