/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.services.emr.model.ConfigurationListCopier;
import software.amazon.awssdk.services.emr.model.StringMapCopier;
import software.amazon.awssdk.services.emr.transform.ConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Configuration
implements StructuredPojo,
ToCopyableBuilder<Builder, Configuration> {
    private final String classification;
    private final List<Configuration> configurations;
    private final Map<String, String> properties;

    private Configuration(BuilderImpl builder) {
        this.classification = builder.classification;
        this.configurations = builder.configurations;
        this.properties = builder.properties;
    }

    public String classification() {
        return this.classification;
    }

    public List<Configuration> configurations() {
        return this.configurations;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.classification() == null ? 0 : this.classification().hashCode());
        hashCode = 31 * hashCode + (this.configurations() == null ? 0 : this.configurations().hashCode());
        hashCode = 31 * hashCode + (this.properties() == null ? 0 : this.properties().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)obj;
        if (other.classification() == null ^ this.classification() == null) {
            return false;
        }
        if (other.classification() != null && !other.classification().equals(this.classification())) {
            return false;
        }
        if (other.configurations() == null ^ this.configurations() == null) {
            return false;
        }
        if (other.configurations() != null && !other.configurations().equals(this.configurations())) {
            return false;
        }
        if (other.properties() == null ^ this.properties() == null) {
            return false;
        }
        return other.properties() == null || other.properties().equals(this.properties());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.classification() != null) {
            sb.append("Classification: ").append(this.classification()).append(",");
        }
        if (this.configurations() != null) {
            sb.append("Configurations: ").append(this.configurations()).append(",");
        }
        if (this.properties() != null) {
            sb.append("Properties: ").append(this.properties()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String classification;
        private List<Configuration> configurations = new SdkInternalList();
        private Map<String, String> properties = new SdkInternalMap();

        private BuilderImpl() {
        }

        private BuilderImpl(Configuration model) {
            this.setClassification(model.classification);
            this.setConfigurations(model.configurations);
            this.setProperties(model.properties);
        }

        public final String getClassification() {
            return this.classification;
        }

        @Override
        public final Builder classification(String classification) {
            this.classification = classification;
            return this;
        }

        public final void setClassification(String classification) {
            this.classification = classification;
        }

        public final Collection<Configuration> getConfigurations() {
            return this.configurations;
        }

        @Override
        public final Builder configurations(Collection<Configuration> configurations) {
            this.configurations = ConfigurationListCopier.copy(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Configuration ... configurations) {
            if (this.configurations == null) {
                this.configurations = new SdkInternalList(configurations.length);
            }
            for (Configuration e : configurations) {
                this.configurations.add(e);
            }
            return this;
        }

        public final void setConfigurations(Collection<Configuration> configurations) {
            this.configurations = ConfigurationListCopier.copy(configurations);
        }

        @SafeVarargs
        public final void setConfigurations(Configuration ... configurations) {
            if (this.configurations == null) {
                this.configurations = new SdkInternalList(configurations.length);
            }
            for (Configuration e : configurations) {
                this.configurations.add(e);
            }
        }

        public final Map<String, String> getProperties() {
            return this.properties;
        }

        @Override
        public final Builder properties(Map<String, String> properties) {
            this.properties = StringMapCopier.copy(properties);
            return this;
        }

        public final void setProperties(Map<String, String> properties) {
            this.properties = StringMapCopier.copy(properties);
        }

        public Configuration build() {
            return new Configuration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Configuration> {
        public Builder classification(String var1);

        public Builder configurations(Collection<Configuration> var1);

        public Builder configurations(Configuration ... var1);

        public Builder properties(Map<String, String> var1);
    }
}

