/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.emr.model.StepConfig;
import software.amazon.awssdk.services.emr.model.StepConfigListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AddJobFlowStepsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AddJobFlowStepsRequest> {
    private final String jobFlowId;
    private final List<StepConfig> steps;

    private AddJobFlowStepsRequest(BuilderImpl builder) {
        this.jobFlowId = builder.jobFlowId;
        this.steps = builder.steps;
    }

    public String jobFlowId() {
        return this.jobFlowId;
    }

    public List<StepConfig> steps() {
        return this.steps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobFlowId() == null ? 0 : this.jobFlowId().hashCode());
        hashCode = 31 * hashCode + (this.steps() == null ? 0 : this.steps().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddJobFlowStepsRequest)) {
            return false;
        }
        AddJobFlowStepsRequest other = (AddJobFlowStepsRequest)((Object)obj);
        if (other.jobFlowId() == null ^ this.jobFlowId() == null) {
            return false;
        }
        if (other.jobFlowId() != null && !other.jobFlowId().equals(this.jobFlowId())) {
            return false;
        }
        if (other.steps() == null ^ this.steps() == null) {
            return false;
        }
        return other.steps() == null || other.steps().equals(this.steps());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jobFlowId() != null) {
            sb.append("JobFlowId: ").append(this.jobFlowId()).append(",");
        }
        if (this.steps() != null) {
            sb.append("Steps: ").append(this.steps()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String jobFlowId;
        private List<StepConfig> steps = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(AddJobFlowStepsRequest model) {
            this.setJobFlowId(model.jobFlowId);
            this.setSteps(model.steps);
        }

        public final String getJobFlowId() {
            return this.jobFlowId;
        }

        @Override
        public final Builder jobFlowId(String jobFlowId) {
            this.jobFlowId = jobFlowId;
            return this;
        }

        public final void setJobFlowId(String jobFlowId) {
            this.jobFlowId = jobFlowId;
        }

        public final Collection<StepConfig> getSteps() {
            return this.steps;
        }

        @Override
        public final Builder steps(Collection<StepConfig> steps) {
            this.steps = StepConfigListCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(StepConfig ... steps) {
            if (this.steps == null) {
                this.steps = new SdkInternalList(steps.length);
            }
            for (StepConfig e : steps) {
                this.steps.add(e);
            }
            return this;
        }

        public final void setSteps(Collection<StepConfig> steps) {
            this.steps = StepConfigListCopier.copy(steps);
        }

        @SafeVarargs
        public final void setSteps(StepConfig ... steps) {
            if (this.steps == null) {
                this.steps = new SdkInternalList(steps.length);
            }
            for (StepConfig e : steps) {
                this.steps.add(e);
            }
        }

        public AddJobFlowStepsRequest build() {
            return new AddJobFlowStepsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AddJobFlowStepsRequest> {
        public Builder jobFlowId(String var1);

        public Builder steps(Collection<StepConfig> var1);

        public Builder steps(StepConfig ... var1);
    }
}

