/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.elastictranscoder.ElasticTranscoderClient;
import software.amazon.awssdk.services.elastictranscoder.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.elastictranscoder.model.ElasticTranscoderRequest;
import software.amazon.awssdk.services.elastictranscoder.model.ReadJobRequest;
import software.amazon.awssdk.services.elastictranscoder.model.ReadJobResponse;
import software.amazon.awssdk.services.elastictranscoder.waiters.ElasticTranscoderWaiter;
import software.amazon.awssdk.services.elastictranscoder.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultElasticTranscoderWaiter
implements ElasticTranscoderWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final ElasticTranscoderClient client;
    private final AttributeMap managedResources;
    private final Waiter<ReadJobResponse> jobCompleteWaiter;

    private DefaultElasticTranscoderWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (ElasticTranscoderClient)ElasticTranscoderClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.jobCompleteWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(ReadJobResponse.class).acceptors(DefaultElasticTranscoderWaiter.jobCompleteWaiterAcceptors())).overrideConfiguration(DefaultElasticTranscoderWaiter.jobCompleteWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<ReadJobResponse> waitUntilJobComplete(ReadJobRequest readJobRequest) {
        return this.jobCompleteWaiter.run(() -> this.client.readJob(this.applyWaitersUserAgent(readJobRequest)));
    }

    @Override
    public WaiterResponse<ReadJobResponse> waitUntilJobComplete(ReadJobRequest readJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.jobCompleteWaiter.run(() -> this.client.readJob(this.applyWaitersUserAgent(readJobRequest)), DefaultElasticTranscoderWaiter.jobCompleteWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super ReadJobResponse>> jobCompleteWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super ReadJobResponse>> result = new ArrayList<WaiterAcceptor<? super ReadJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Job").field("Status").value(), "Complete");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Job").field("Status").value(), "Canceled");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Job.Status=Canceled) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Job").field("Status").value(), "Error");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Job.Status=Error) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration jobCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static ElasticTranscoderWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends ElasticTranscoderRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ElasticTranscoderRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements ElasticTranscoderWaiter.Builder {
        private ElasticTranscoderClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public ElasticTranscoderWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public ElasticTranscoderWaiter.Builder client(ElasticTranscoderClient client) {
            this.client = client;
            return this;
        }

        @Override
        public ElasticTranscoderWaiter build() {
            return new DefaultElasticTranscoderWaiter(this);
        }
    }
}

