/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elastictranscoder.ElasticTranscoderAsyncClient;
import software.amazon.awssdk.services.elastictranscoder.model.ListPresetsRequest;
import software.amazon.awssdk.services.elastictranscoder.model.ListPresetsResponse;
import software.amazon.awssdk.services.elastictranscoder.model.Preset;

public class ListPresetsPublisher
implements SdkPublisher<ListPresetsResponse> {
    private final ElasticTranscoderAsyncClient client;
    private final ListPresetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPresetsPublisher(ElasticTranscoderAsyncClient client, ListPresetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPresetsPublisher(ElasticTranscoderAsyncClient client, ListPresetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPresetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPresetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Preset> presets() {
        Function<ListPresetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.presets() != null) {
                return response.presets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPresetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPresetsResponseFetcher
    implements AsyncPageFetcher<ListPresetsResponse> {
        private ListPresetsResponseFetcher() {
        }

        public boolean hasNextPage(ListPresetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<ListPresetsResponse> nextPage(ListPresetsResponse previousPage) {
            if (previousPage == null) {
                return ListPresetsPublisher.this.client.listPresets(ListPresetsPublisher.this.firstRequest);
            }
            return ListPresetsPublisher.this.client.listPresets((ListPresetsRequest)((Object)ListPresetsPublisher.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

