/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elastictranscoder.model.DetectedProperties;
import software.amazon.awssdk.services.elastictranscoder.model.Encryption;
import software.amazon.awssdk.services.elastictranscoder.model.InputCaptions;
import software.amazon.awssdk.services.elastictranscoder.model.TimeSpan;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobInput> {
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(JobInput.getter(JobInput::key)).setter(JobInput.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()}).build();
    private static final SdkField<String> FRAME_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FrameRate").getter(JobInput.getter(JobInput::frameRate)).setter(JobInput.setter(Builder::frameRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameRate").build()}).build();
    private static final SdkField<String> RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Resolution").getter(JobInput.getter(JobInput::resolution)).setter(JobInput.setter(Builder::resolution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resolution").build()}).build();
    private static final SdkField<String> ASPECT_RATIO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AspectRatio").getter(JobInput.getter(JobInput::aspectRatio)).setter(JobInput.setter(Builder::aspectRatio)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AspectRatio").build()}).build();
    private static final SdkField<String> INTERLACED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Interlaced").getter(JobInput.getter(JobInput::interlaced)).setter(JobInput.setter(Builder::interlaced)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interlaced").build()}).build();
    private static final SdkField<String> CONTAINER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Container").getter(JobInput.getter(JobInput::container)).setter(JobInput.setter(Builder::container)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Container").build()}).build();
    private static final SdkField<Encryption> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Encryption").getter(JobInput.getter(JobInput::encryption)).setter(JobInput.setter(Builder::encryption)).constructor(Encryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encryption").build()}).build();
    private static final SdkField<TimeSpan> TIME_SPAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeSpan").getter(JobInput.getter(JobInput::timeSpan)).setter(JobInput.setter(Builder::timeSpan)).constructor(TimeSpan::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSpan").build()}).build();
    private static final SdkField<InputCaptions> INPUT_CAPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputCaptions").getter(JobInput.getter(JobInput::inputCaptions)).setter(JobInput.setter(Builder::inputCaptions)).constructor(InputCaptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputCaptions").build()}).build();
    private static final SdkField<DetectedProperties> DETECTED_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DetectedProperties").getter(JobInput.getter(JobInput::detectedProperties)).setter(JobInput.setter(Builder::detectedProperties)).constructor(DetectedProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetectedProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, FRAME_RATE_FIELD, RESOLUTION_FIELD, ASPECT_RATIO_FIELD, INTERLACED_FIELD, CONTAINER_FIELD, ENCRYPTION_FIELD, TIME_SPAN_FIELD, INPUT_CAPTIONS_FIELD, DETECTED_PROPERTIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String key;
    private final String frameRate;
    private final String resolution;
    private final String aspectRatio;
    private final String interlaced;
    private final String container;
    private final Encryption encryption;
    private final TimeSpan timeSpan;
    private final InputCaptions inputCaptions;
    private final DetectedProperties detectedProperties;

    private JobInput(BuilderImpl builder) {
        this.key = builder.key;
        this.frameRate = builder.frameRate;
        this.resolution = builder.resolution;
        this.aspectRatio = builder.aspectRatio;
        this.interlaced = builder.interlaced;
        this.container = builder.container;
        this.encryption = builder.encryption;
        this.timeSpan = builder.timeSpan;
        this.inputCaptions = builder.inputCaptions;
        this.detectedProperties = builder.detectedProperties;
    }

    public final String key() {
        return this.key;
    }

    public final String frameRate() {
        return this.frameRate;
    }

    public final String resolution() {
        return this.resolution;
    }

    public final String aspectRatio() {
        return this.aspectRatio;
    }

    public final String interlaced() {
        return this.interlaced;
    }

    public final String container() {
        return this.container;
    }

    public final Encryption encryption() {
        return this.encryption;
    }

    public final TimeSpan timeSpan() {
        return this.timeSpan;
    }

    public final InputCaptions inputCaptions() {
        return this.inputCaptions;
    }

    public final DetectedProperties detectedProperties() {
        return this.detectedProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolution());
        hashCode = 31 * hashCode + Objects.hashCode(this.aspectRatio());
        hashCode = 31 * hashCode + Objects.hashCode(this.interlaced());
        hashCode = 31 * hashCode + Objects.hashCode(this.container());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeSpan());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputCaptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectedProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobInput)) {
            return false;
        }
        JobInput other = (JobInput)obj;
        return Objects.equals(this.key(), other.key()) && Objects.equals(this.frameRate(), other.frameRate()) && Objects.equals(this.resolution(), other.resolution()) && Objects.equals(this.aspectRatio(), other.aspectRatio()) && Objects.equals(this.interlaced(), other.interlaced()) && Objects.equals(this.container(), other.container()) && Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.timeSpan(), other.timeSpan()) && Objects.equals(this.inputCaptions(), other.inputCaptions()) && Objects.equals(this.detectedProperties(), other.detectedProperties());
    }

    public final String toString() {
        return ToString.builder((String)"JobInput").add("Key", (Object)this.key()).add("FrameRate", (Object)this.frameRate()).add("Resolution", (Object)this.resolution()).add("AspectRatio", (Object)this.aspectRatio()).add("Interlaced", (Object)this.interlaced()).add("Container", (Object)this.container()).add("Encryption", (Object)this.encryption()).add("TimeSpan", (Object)this.timeSpan()).add("InputCaptions", (Object)this.inputCaptions()).add("DetectedProperties", (Object)this.detectedProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "FrameRate": {
                return Optional.ofNullable(clazz.cast(this.frameRate()));
            }
            case "Resolution": {
                return Optional.ofNullable(clazz.cast(this.resolution()));
            }
            case "AspectRatio": {
                return Optional.ofNullable(clazz.cast(this.aspectRatio()));
            }
            case "Interlaced": {
                return Optional.ofNullable(clazz.cast(this.interlaced()));
            }
            case "Container": {
                return Optional.ofNullable(clazz.cast(this.container()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "TimeSpan": {
                return Optional.ofNullable(clazz.cast(this.timeSpan()));
            }
            case "InputCaptions": {
                return Optional.ofNullable(clazz.cast(this.inputCaptions()));
            }
            case "DetectedProperties": {
                return Optional.ofNullable(clazz.cast(this.detectedProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobInput, T> g) {
        return obj -> g.apply((JobInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private String frameRate;
        private String resolution;
        private String aspectRatio;
        private String interlaced;
        private String container;
        private Encryption encryption;
        private TimeSpan timeSpan;
        private InputCaptions inputCaptions;
        private DetectedProperties detectedProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(JobInput model) {
            this.key(model.key);
            this.frameRate(model.frameRate);
            this.resolution(model.resolution);
            this.aspectRatio(model.aspectRatio);
            this.interlaced(model.interlaced);
            this.container(model.container);
            this.encryption(model.encryption);
            this.timeSpan(model.timeSpan);
            this.inputCaptions(model.inputCaptions);
            this.detectedProperties(model.detectedProperties);
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getFrameRate() {
            return this.frameRate;
        }

        @Override
        public final Builder frameRate(String frameRate) {
            this.frameRate = frameRate;
            return this;
        }

        public final void setFrameRate(String frameRate) {
            this.frameRate = frameRate;
        }

        public final String getResolution() {
            return this.resolution;
        }

        @Override
        public final Builder resolution(String resolution) {
            this.resolution = resolution;
            return this;
        }

        public final void setResolution(String resolution) {
            this.resolution = resolution;
        }

        public final String getAspectRatio() {
            return this.aspectRatio;
        }

        @Override
        public final Builder aspectRatio(String aspectRatio) {
            this.aspectRatio = aspectRatio;
            return this;
        }

        public final void setAspectRatio(String aspectRatio) {
            this.aspectRatio = aspectRatio;
        }

        public final String getInterlaced() {
            return this.interlaced;
        }

        @Override
        public final Builder interlaced(String interlaced) {
            this.interlaced = interlaced;
            return this;
        }

        public final void setInterlaced(String interlaced) {
            this.interlaced = interlaced;
        }

        public final String getContainer() {
            return this.container;
        }

        @Override
        public final Builder container(String container) {
            this.container = container;
            return this;
        }

        public final void setContainer(String container) {
            this.container = container;
        }

        public final Encryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(Encryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(Encryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final TimeSpan.Builder getTimeSpan() {
            return this.timeSpan != null ? this.timeSpan.toBuilder() : null;
        }

        @Override
        public final Builder timeSpan(TimeSpan timeSpan) {
            this.timeSpan = timeSpan;
            return this;
        }

        public final void setTimeSpan(TimeSpan.BuilderImpl timeSpan) {
            this.timeSpan = timeSpan != null ? timeSpan.build() : null;
        }

        public final InputCaptions.Builder getInputCaptions() {
            return this.inputCaptions != null ? this.inputCaptions.toBuilder() : null;
        }

        @Override
        public final Builder inputCaptions(InputCaptions inputCaptions) {
            this.inputCaptions = inputCaptions;
            return this;
        }

        public final void setInputCaptions(InputCaptions.BuilderImpl inputCaptions) {
            this.inputCaptions = inputCaptions != null ? inputCaptions.build() : null;
        }

        public final DetectedProperties.Builder getDetectedProperties() {
            return this.detectedProperties != null ? this.detectedProperties.toBuilder() : null;
        }

        @Override
        public final Builder detectedProperties(DetectedProperties detectedProperties) {
            this.detectedProperties = detectedProperties;
            return this;
        }

        public final void setDetectedProperties(DetectedProperties.BuilderImpl detectedProperties) {
            this.detectedProperties = detectedProperties != null ? detectedProperties.build() : null;
        }

        public JobInput build() {
            return new JobInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobInput> {
        public Builder key(String var1);

        public Builder frameRate(String var1);

        public Builder resolution(String var1);

        public Builder aspectRatio(String var1);

        public Builder interlaced(String var1);

        public Builder container(String var1);

        public Builder encryption(Encryption var1);

        default public Builder encryption(Consumer<Encryption.Builder> encryption) {
            return this.encryption((Encryption)((Encryption.Builder)Encryption.builder().applyMutation(encryption)).build());
        }

        public Builder timeSpan(TimeSpan var1);

        default public Builder timeSpan(Consumer<TimeSpan.Builder> timeSpan) {
            return this.timeSpan((TimeSpan)((TimeSpan.Builder)TimeSpan.builder().applyMutation(timeSpan)).build());
        }

        public Builder inputCaptions(InputCaptions var1);

        default public Builder inputCaptions(Consumer<InputCaptions.Builder> inputCaptions) {
            return this.inputCaptions((InputCaptions)((InputCaptions.Builder)InputCaptions.builder().applyMutation(inputCaptions)).build());
        }

        public Builder detectedProperties(DetectedProperties var1);

        default public Builder detectedProperties(Consumer<DetectedProperties.Builder> detectedProperties) {
            return this.detectedProperties((DetectedProperties)((DetectedProperties.Builder)DetectedProperties.builder().applyMutation(detectedProperties)).build());
        }
    }
}

