/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elastictranscoder.model.AudioParameters;
import software.amazon.awssdk.services.elastictranscoder.model.ElasticTranscoderRequest;
import software.amazon.awssdk.services.elastictranscoder.model.Thumbnails;
import software.amazon.awssdk.services.elastictranscoder.model.VideoParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePresetRequest
extends ElasticTranscoderRequest
implements ToCopyableBuilder<Builder, CreatePresetRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreatePresetRequest.getter(CreatePresetRequest::name)).setter(CreatePresetRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreatePresetRequest.getter(CreatePresetRequest::description)).setter(CreatePresetRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CONTAINER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Container").getter(CreatePresetRequest.getter(CreatePresetRequest::container)).setter(CreatePresetRequest.setter(Builder::container)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Container").build()}).build();
    private static final SdkField<VideoParameters> VIDEO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Video").getter(CreatePresetRequest.getter(CreatePresetRequest::video)).setter(CreatePresetRequest.setter(Builder::video)).constructor(VideoParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Video").build()}).build();
    private static final SdkField<AudioParameters> AUDIO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Audio").getter(CreatePresetRequest.getter(CreatePresetRequest::audio)).setter(CreatePresetRequest.setter(Builder::audio)).constructor(AudioParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Audio").build()}).build();
    private static final SdkField<Thumbnails> THUMBNAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Thumbnails").getter(CreatePresetRequest.getter(CreatePresetRequest::thumbnails)).setter(CreatePresetRequest.setter(Builder::thumbnails)).constructor(Thumbnails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Thumbnails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, CONTAINER_FIELD, VIDEO_FIELD, AUDIO_FIELD, THUMBNAILS_FIELD));
    private final String name;
    private final String description;
    private final String container;
    private final VideoParameters video;
    private final AudioParameters audio;
    private final Thumbnails thumbnails;

    private CreatePresetRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.container = builder.container;
        this.video = builder.video;
        this.audio = builder.audio;
        this.thumbnails = builder.thumbnails;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String container() {
        return this.container;
    }

    public final VideoParameters video() {
        return this.video;
    }

    public final AudioParameters audio() {
        return this.audio;
    }

    public final Thumbnails thumbnails() {
        return this.thumbnails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.container());
        hashCode = 31 * hashCode + Objects.hashCode(this.video());
        hashCode = 31 * hashCode + Objects.hashCode(this.audio());
        hashCode = 31 * hashCode + Objects.hashCode(this.thumbnails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePresetRequest)) {
            return false;
        }
        CreatePresetRequest other = (CreatePresetRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.container(), other.container()) && Objects.equals(this.video(), other.video()) && Objects.equals(this.audio(), other.audio()) && Objects.equals(this.thumbnails(), other.thumbnails());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePresetRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Container", (Object)this.container()).add("Video", (Object)this.video()).add("Audio", (Object)this.audio()).add("Thumbnails", (Object)this.thumbnails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Container": {
                return Optional.ofNullable(clazz.cast(this.container()));
            }
            case "Video": {
                return Optional.ofNullable(clazz.cast(this.video()));
            }
            case "Audio": {
                return Optional.ofNullable(clazz.cast(this.audio()));
            }
            case "Thumbnails": {
                return Optional.ofNullable(clazz.cast(this.thumbnails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePresetRequest, T> g) {
        return obj -> g.apply((CreatePresetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticTranscoderRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String container;
        private VideoParameters video;
        private AudioParameters audio;
        private Thumbnails thumbnails;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePresetRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.container(model.container);
            this.video(model.video);
            this.audio(model.audio);
            this.thumbnails(model.thumbnails);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getContainer() {
            return this.container;
        }

        @Override
        public final Builder container(String container) {
            this.container = container;
            return this;
        }

        public final void setContainer(String container) {
            this.container = container;
        }

        public final VideoParameters.Builder getVideo() {
            return this.video != null ? this.video.toBuilder() : null;
        }

        @Override
        public final Builder video(VideoParameters video) {
            this.video = video;
            return this;
        }

        public final void setVideo(VideoParameters.BuilderImpl video) {
            this.video = video != null ? video.build() : null;
        }

        public final AudioParameters.Builder getAudio() {
            return this.audio != null ? this.audio.toBuilder() : null;
        }

        @Override
        public final Builder audio(AudioParameters audio) {
            this.audio = audio;
            return this;
        }

        public final void setAudio(AudioParameters.BuilderImpl audio) {
            this.audio = audio != null ? audio.build() : null;
        }

        public final Thumbnails.Builder getThumbnails() {
            return this.thumbnails != null ? this.thumbnails.toBuilder() : null;
        }

        @Override
        public final Builder thumbnails(Thumbnails thumbnails) {
            this.thumbnails = thumbnails;
            return this;
        }

        public final void setThumbnails(Thumbnails.BuilderImpl thumbnails) {
            this.thumbnails = thumbnails != null ? thumbnails.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePresetRequest build() {
            return new CreatePresetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticTranscoderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePresetRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder container(String var1);

        public Builder video(VideoParameters var1);

        default public Builder video(Consumer<VideoParameters.Builder> video) {
            return this.video((VideoParameters)((VideoParameters.Builder)VideoParameters.builder().applyMutation(video)).build());
        }

        public Builder audio(AudioParameters var1);

        default public Builder audio(Consumer<AudioParameters.Builder> audio) {
            return this.audio((AudioParameters)((AudioParameters.Builder)AudioParameters.builder().applyMutation(audio)).build());
        }

        public Builder thumbnails(Thumbnails var1);

        default public Builder thumbnails(Consumer<Thumbnails.Builder> thumbnails) {
            return this.thumbnails((Thumbnails)((Thumbnails.Builder)Thumbnails.builder().applyMutation(thumbnails)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

