/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elastictranscoder.model.CaptionFormat;
import software.amazon.awssdk.services.elastictranscoder.model.CaptionFormatsCopier;
import software.amazon.awssdk.services.elastictranscoder.model.CaptionSource;
import software.amazon.awssdk.services.elastictranscoder.model.CaptionSourcesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Captions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Captions> {
    private static final SdkField<String> MERGE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Captions.getter(Captions::mergePolicy)).setter(Captions.setter(Builder::mergePolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MergePolicy").build()}).build();
    private static final SdkField<List<CaptionSource>> CAPTION_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Captions.getter(Captions::captionSources)).setter(Captions.setter(Builder::captionSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaptionSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CaptionSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CaptionFormat>> CAPTION_FORMATS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Captions.getter(Captions::captionFormats)).setter(Captions.setter(Builder::captionFormats)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaptionFormats").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CaptionFormat::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MERGE_POLICY_FIELD, CAPTION_SOURCES_FIELD, CAPTION_FORMATS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String mergePolicy;
    private final List<CaptionSource> captionSources;
    private final List<CaptionFormat> captionFormats;

    private Captions(BuilderImpl builder) {
        this.mergePolicy = builder.mergePolicy;
        this.captionSources = builder.captionSources;
        this.captionFormats = builder.captionFormats;
    }

    public String mergePolicy() {
        return this.mergePolicy;
    }

    public boolean hasCaptionSources() {
        return this.captionSources != null && !(this.captionSources instanceof SdkAutoConstructList);
    }

    public List<CaptionSource> captionSources() {
        return this.captionSources;
    }

    public boolean hasCaptionFormats() {
        return this.captionFormats != null && !(this.captionFormats instanceof SdkAutoConstructList);
    }

    public List<CaptionFormat> captionFormats() {
        return this.captionFormats;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mergePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.captionSources());
        hashCode = 31 * hashCode + Objects.hashCode(this.captionFormats());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Captions)) {
            return false;
        }
        Captions other = (Captions)obj;
        return Objects.equals(this.mergePolicy(), other.mergePolicy()) && Objects.equals(this.captionSources(), other.captionSources()) && Objects.equals(this.captionFormats(), other.captionFormats());
    }

    public String toString() {
        return ToString.builder((String)"Captions").add("MergePolicy", (Object)this.mergePolicy()).add("CaptionSources", this.captionSources()).add("CaptionFormats", this.captionFormats()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MergePolicy": {
                return Optional.ofNullable(clazz.cast(this.mergePolicy()));
            }
            case "CaptionSources": {
                return Optional.ofNullable(clazz.cast(this.captionSources()));
            }
            case "CaptionFormats": {
                return Optional.ofNullable(clazz.cast(this.captionFormats()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Captions, T> g) {
        return obj -> g.apply((Captions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mergePolicy;
        private List<CaptionSource> captionSources = DefaultSdkAutoConstructList.getInstance();
        private List<CaptionFormat> captionFormats = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Captions model) {
            this.mergePolicy(model.mergePolicy);
            this.captionSources(model.captionSources);
            this.captionFormats(model.captionFormats);
        }

        public final String getMergePolicy() {
            return this.mergePolicy;
        }

        @Override
        public final Builder mergePolicy(String mergePolicy) {
            this.mergePolicy = mergePolicy;
            return this;
        }

        public final void setMergePolicy(String mergePolicy) {
            this.mergePolicy = mergePolicy;
        }

        public final Collection<CaptionSource.Builder> getCaptionSources() {
            return this.captionSources != null ? (Collection)this.captionSources.stream().map(CaptionSource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder captionSources(Collection<CaptionSource> captionSources) {
            this.captionSources = CaptionSourcesCopier.copy(captionSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionSources(CaptionSource ... captionSources) {
            this.captionSources(Arrays.asList(captionSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionSources(Consumer<CaptionSource.Builder> ... captionSources) {
            this.captionSources(Stream.of(captionSources).map(c -> (CaptionSource)((CaptionSource.Builder)CaptionSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCaptionSources(Collection<CaptionSource.BuilderImpl> captionSources) {
            this.captionSources = CaptionSourcesCopier.copyFromBuilder(captionSources);
        }

        public final Collection<CaptionFormat.Builder> getCaptionFormats() {
            return this.captionFormats != null ? (Collection)this.captionFormats.stream().map(CaptionFormat::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder captionFormats(Collection<CaptionFormat> captionFormats) {
            this.captionFormats = CaptionFormatsCopier.copy(captionFormats);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionFormats(CaptionFormat ... captionFormats) {
            this.captionFormats(Arrays.asList(captionFormats));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionFormats(Consumer<CaptionFormat.Builder> ... captionFormats) {
            this.captionFormats(Stream.of(captionFormats).map(c -> (CaptionFormat)((CaptionFormat.Builder)CaptionFormat.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCaptionFormats(Collection<CaptionFormat.BuilderImpl> captionFormats) {
            this.captionFormats = CaptionFormatsCopier.copyFromBuilder(captionFormats);
        }

        public Captions build() {
            return new Captions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Captions> {
        public Builder mergePolicy(String var1);

        public Builder captionSources(Collection<CaptionSource> var1);

        public Builder captionSources(CaptionSource ... var1);

        public Builder captionSources(Consumer<CaptionSource.Builder> ... var1);

        public Builder captionFormats(Collection<CaptionFormat> var1);

        public Builder captionFormats(CaptionFormat ... var1);

        public Builder captionFormats(Consumer<CaptionFormat.Builder> ... var1);
    }
}

