/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>ListPresetsResponse</code> structure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPresetsResponse extends ElasticTranscoderResponse implements
        ToCopyableBuilder<ListPresetsResponse.Builder, ListPresetsResponse> {
    private static final SdkField<List<Preset>> PRESETS_FIELD = SdkField
            .<List<Preset>> builder(MarshallingType.LIST)
            .getter(getter(ListPresetsResponse::presets))
            .setter(setter(Builder::presets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Presets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Preset> builder(MarshallingType.SDK_POJO)
                                            .constructor(Preset::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListPresetsResponse::nextPageToken)).setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRESETS_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private final List<Preset> presets;

    private final String nextPageToken;

    private ListPresetsResponse(BuilderImpl builder) {
        super(builder);
        this.presets = builder.presets;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * Returns true if the Presets property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPresets() {
        return presets != null && !(presets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>Preset</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPresets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>Preset</code> objects.
     */
    public List<Preset> presets() {
        return presets;
    }

    /**
     * <p>
     * A value that you use to access the second and subsequent pages of results, if any. When the presets fit on one
     * page or when you've reached the last page of results, the value of <code>NextPageToken</code> is
     * <code>null</code>.
     * </p>
     * 
     * @return A value that you use to access the second and subsequent pages of results, if any. When the presets fit
     *         on one page or when you've reached the last page of results, the value of <code>NextPageToken</code> is
     *         <code>null</code>.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(presets());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPresetsResponse)) {
            return false;
        }
        ListPresetsResponse other = (ListPresetsResponse) obj;
        return Objects.equals(presets(), other.presets()) && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListPresetsResponse").add("Presets", presets()).add("NextPageToken", nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Presets":
            return Optional.ofNullable(clazz.cast(presets()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPresetsResponse, T> g) {
        return obj -> g.apply((ListPresetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticTranscoderResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPresetsResponse> {
        /**
         * <p>
         * An array of <code>Preset</code> objects.
         * </p>
         * 
         * @param presets
         *        An array of <code>Preset</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder presets(Collection<Preset> presets);

        /**
         * <p>
         * An array of <code>Preset</code> objects.
         * </p>
         * 
         * @param presets
         *        An array of <code>Preset</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder presets(Preset... presets);

        /**
         * <p>
         * An array of <code>Preset</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Preset>.Builder} avoiding the need to
         * create one manually via {@link List<Preset>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Preset>.Builder#build()} is called immediately and its
         * result is passed to {@link #presets(List<Preset>)}.
         * 
         * @param presets
         *        a consumer that will call methods on {@link List<Preset>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #presets(List<Preset>)
         */
        Builder presets(Consumer<Preset.Builder>... presets);

        /**
         * <p>
         * A value that you use to access the second and subsequent pages of results, if any. When the presets fit on
         * one page or when you've reached the last page of results, the value of <code>NextPageToken</code> is
         * <code>null</code>.
         * </p>
         * 
         * @param nextPageToken
         *        A value that you use to access the second and subsequent pages of results, if any. When the presets
         *        fit on one page or when you've reached the last page of results, the value of
         *        <code>NextPageToken</code> is <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends ElasticTranscoderResponse.BuilderImpl implements Builder {
        private List<Preset> presets = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPresetsResponse model) {
            super(model);
            presets(model.presets);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<Preset.Builder> getPresets() {
            return presets != null ? presets.stream().map(Preset::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder presets(Collection<Preset> presets) {
            this.presets = PresetsCopier.copy(presets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder presets(Preset... presets) {
            presets(Arrays.asList(presets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder presets(Consumer<Preset.Builder>... presets) {
            presets(Stream.of(presets).map(c -> Preset.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPresets(Collection<Preset.BuilderImpl> presets) {
            this.presets = PresetsCopier.copyFromBuilder(presets);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ListPresetsResponse build() {
            return new ListPresetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
