/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of the pipelines associated with the current AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPipelinesResponse extends ElasticTranscoderResponse implements
        ToCopyableBuilder<ListPipelinesResponse.Builder, ListPipelinesResponse> {
    private static final SdkField<List<Pipeline>> PIPELINES_FIELD = SdkField
            .<List<Pipeline>> builder(MarshallingType.LIST)
            .getter(getter(ListPipelinesResponse::pipelines))
            .setter(setter(Builder::pipelines))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pipelines").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Pipeline> builder(MarshallingType.SDK_POJO)
                                            .constructor(Pipeline::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListPipelinesResponse::nextPageToken)).setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINES_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private final List<Pipeline> pipelines;

    private final String nextPageToken;

    private ListPipelinesResponse(BuilderImpl builder) {
        super(builder);
        this.pipelines = builder.pipelines;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * Returns true if the Pipelines property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPipelines() {
        return pipelines != null && !(pipelines instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>Pipeline</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPipelines()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>Pipeline</code> objects.
     */
    public List<Pipeline> pipelines() {
        return pipelines;
    }

    /**
     * <p>
     * A value that you use to access the second and subsequent pages of results, if any. When the pipelines fit on one
     * page or when you've reached the last page of results, the value of <code>NextPageToken</code> is
     * <code>null</code>.
     * </p>
     * 
     * @return A value that you use to access the second and subsequent pages of results, if any. When the pipelines fit
     *         on one page or when you've reached the last page of results, the value of <code>NextPageToken</code> is
     *         <code>null</code>.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelines());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipelinesResponse)) {
            return false;
        }
        ListPipelinesResponse other = (ListPipelinesResponse) obj;
        return Objects.equals(pipelines(), other.pipelines()) && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListPipelinesResponse").add("Pipelines", pipelines()).add("NextPageToken", nextPageToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Pipelines":
            return Optional.ofNullable(clazz.cast(pipelines()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPipelinesResponse, T> g) {
        return obj -> g.apply((ListPipelinesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticTranscoderResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPipelinesResponse> {
        /**
         * <p>
         * An array of <code>Pipeline</code> objects.
         * </p>
         * 
         * @param pipelines
         *        An array of <code>Pipeline</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelines(Collection<Pipeline> pipelines);

        /**
         * <p>
         * An array of <code>Pipeline</code> objects.
         * </p>
         * 
         * @param pipelines
         *        An array of <code>Pipeline</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelines(Pipeline... pipelines);

        /**
         * <p>
         * An array of <code>Pipeline</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Pipeline>.Builder} avoiding the need to
         * create one manually via {@link List<Pipeline>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Pipeline>.Builder#build()} is called immediately and its
         * result is passed to {@link #pipelines(List<Pipeline>)}.
         * 
         * @param pipelines
         *        a consumer that will call methods on {@link List<Pipeline>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelines(List<Pipeline>)
         */
        Builder pipelines(Consumer<Pipeline.Builder>... pipelines);

        /**
         * <p>
         * A value that you use to access the second and subsequent pages of results, if any. When the pipelines fit on
         * one page or when you've reached the last page of results, the value of <code>NextPageToken</code> is
         * <code>null</code>.
         * </p>
         * 
         * @param nextPageToken
         *        A value that you use to access the second and subsequent pages of results, if any. When the pipelines
         *        fit on one page or when you've reached the last page of results, the value of
         *        <code>NextPageToken</code> is <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends ElasticTranscoderResponse.BuilderImpl implements Builder {
        private List<Pipeline> pipelines = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPipelinesResponse model) {
            super(model);
            pipelines(model.pipelines);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<Pipeline.Builder> getPipelines() {
            return pipelines != null ? pipelines.stream().map(Pipeline::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pipelines(Collection<Pipeline> pipelines) {
            this.pipelines = PipelinesCopier.copy(pipelines);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelines(Pipeline... pipelines) {
            pipelines(Arrays.asList(pipelines));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelines(Consumer<Pipeline.Builder>... pipelines) {
            pipelines(Stream.of(pipelines).map(c -> Pipeline.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPipelines(Collection<Pipeline.BuilderImpl> pipelines) {
            this.pipelines = PipelinesCopier.copyFromBuilder(pipelines);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ListPipelinesResponse build() {
            return new ListPipelinesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
