/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticsearch.model.SAMLIdp;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SAMLOptionsOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SAMLOptionsOutput> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(SAMLOptionsOutput.getter(SAMLOptionsOutput::enabled)).setter(SAMLOptionsOutput.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<SAMLIdp> IDP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Idp").getter(SAMLOptionsOutput.getter(SAMLOptionsOutput::idp)).setter(SAMLOptionsOutput.setter(Builder::idp)).constructor(SAMLIdp::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Idp").build()}).build();
    private static final SdkField<String> SUBJECT_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubjectKey").getter(SAMLOptionsOutput.getter(SAMLOptionsOutput::subjectKey)).setter(SAMLOptionsOutput.setter(Builder::subjectKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubjectKey").build()}).build();
    private static final SdkField<String> ROLES_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RolesKey").getter(SAMLOptionsOutput.getter(SAMLOptionsOutput::rolesKey)).setter(SAMLOptionsOutput.setter(Builder::rolesKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RolesKey").build()}).build();
    private static final SdkField<Integer> SESSION_TIMEOUT_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SessionTimeoutMinutes").getter(SAMLOptionsOutput.getter(SAMLOptionsOutput::sessionTimeoutMinutes)).setter(SAMLOptionsOutput.setter(Builder::sessionTimeoutMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionTimeoutMinutes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, IDP_FIELD, SUBJECT_KEY_FIELD, ROLES_KEY_FIELD, SESSION_TIMEOUT_MINUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SAMLOptionsOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final SAMLIdp idp;
    private final String subjectKey;
    private final String rolesKey;
    private final Integer sessionTimeoutMinutes;

    private SAMLOptionsOutput(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.idp = builder.idp;
        this.subjectKey = builder.subjectKey;
        this.rolesKey = builder.rolesKey;
        this.sessionTimeoutMinutes = builder.sessionTimeoutMinutes;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final SAMLIdp idp() {
        return this.idp;
    }

    public final String subjectKey() {
        return this.subjectKey;
    }

    public final String rolesKey() {
        return this.rolesKey;
    }

    public final Integer sessionTimeoutMinutes() {
        return this.sessionTimeoutMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.idp());
        hashCode = 31 * hashCode + Objects.hashCode(this.subjectKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.rolesKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionTimeoutMinutes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SAMLOptionsOutput)) {
            return false;
        }
        SAMLOptionsOutput other = (SAMLOptionsOutput)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.idp(), other.idp()) && Objects.equals(this.subjectKey(), other.subjectKey()) && Objects.equals(this.rolesKey(), other.rolesKey()) && Objects.equals(this.sessionTimeoutMinutes(), other.sessionTimeoutMinutes());
    }

    public final String toString() {
        return ToString.builder((String)"SAMLOptionsOutput").add("Enabled", (Object)this.enabled()).add("Idp", (Object)this.idp()).add("SubjectKey", (Object)this.subjectKey()).add("RolesKey", (Object)this.rolesKey()).add("SessionTimeoutMinutes", (Object)this.sessionTimeoutMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "Idp": {
                return Optional.ofNullable(clazz.cast(this.idp()));
            }
            case "SubjectKey": {
                return Optional.ofNullable(clazz.cast(this.subjectKey()));
            }
            case "RolesKey": {
                return Optional.ofNullable(clazz.cast(this.rolesKey()));
            }
            case "SessionTimeoutMinutes": {
                return Optional.ofNullable(clazz.cast(this.sessionTimeoutMinutes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Enabled", ENABLED_FIELD);
        map.put("Idp", IDP_FIELD);
        map.put("SubjectKey", SUBJECT_KEY_FIELD);
        map.put("RolesKey", ROLES_KEY_FIELD);
        map.put("SessionTimeoutMinutes", SESSION_TIMEOUT_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SAMLOptionsOutput, T> g) {
        return obj -> g.apply((SAMLOptionsOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private SAMLIdp idp;
        private String subjectKey;
        private String rolesKey;
        private Integer sessionTimeoutMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(SAMLOptionsOutput model) {
            this.enabled(model.enabled);
            this.idp(model.idp);
            this.subjectKey(model.subjectKey);
            this.rolesKey(model.rolesKey);
            this.sessionTimeoutMinutes(model.sessionTimeoutMinutes);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final SAMLIdp.Builder getIdp() {
            return this.idp != null ? this.idp.toBuilder() : null;
        }

        public final void setIdp(SAMLIdp.BuilderImpl idp) {
            this.idp = idp != null ? idp.build() : null;
        }

        @Override
        public final Builder idp(SAMLIdp idp) {
            this.idp = idp;
            return this;
        }

        public final String getSubjectKey() {
            return this.subjectKey;
        }

        public final void setSubjectKey(String subjectKey) {
            this.subjectKey = subjectKey;
        }

        @Override
        public final Builder subjectKey(String subjectKey) {
            this.subjectKey = subjectKey;
            return this;
        }

        public final String getRolesKey() {
            return this.rolesKey;
        }

        public final void setRolesKey(String rolesKey) {
            this.rolesKey = rolesKey;
        }

        @Override
        public final Builder rolesKey(String rolesKey) {
            this.rolesKey = rolesKey;
            return this;
        }

        public final Integer getSessionTimeoutMinutes() {
            return this.sessionTimeoutMinutes;
        }

        public final void setSessionTimeoutMinutes(Integer sessionTimeoutMinutes) {
            this.sessionTimeoutMinutes = sessionTimeoutMinutes;
        }

        @Override
        public final Builder sessionTimeoutMinutes(Integer sessionTimeoutMinutes) {
            this.sessionTimeoutMinutes = sessionTimeoutMinutes;
            return this;
        }

        public SAMLOptionsOutput build() {
            return new SAMLOptionsOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SAMLOptionsOutput> {
        public Builder enabled(Boolean var1);

        public Builder idp(SAMLIdp var1);

        default public Builder idp(Consumer<SAMLIdp.Builder> idp) {
            return this.idp((SAMLIdp)((SAMLIdp.Builder)SAMLIdp.builder().applyMutation(idp)).build());
        }

        public Builder subjectKey(String var1);

        public Builder rolesKey(String var1);

        public Builder sessionTimeoutMinutes(Integer var1);
    }
}

