/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticsearch.model.DomainInfo;
import software.amazon.awssdk.services.elasticsearch.model.DomainInfoListCopier;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDomainNamesResponse
extends ElasticsearchResponse
implements ToCopyableBuilder<Builder, ListDomainNamesResponse> {
    private static final SdkField<List<DomainInfo>> DOMAIN_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DomainNames").getter(ListDomainNamesResponse.getter(ListDomainNamesResponse::domainNames)).setter(ListDomainNamesResponse.setter(Builder::domainNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAMES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DomainNames", DOMAIN_NAMES_FIELD);
        }
    });
    private final List<DomainInfo> domainNames;

    private ListDomainNamesResponse(BuilderImpl builder) {
        super(builder);
        this.domainNames = builder.domainNames;
    }

    public final boolean hasDomainNames() {
        return this.domainNames != null && !(this.domainNames instanceof SdkAutoConstructList);
    }

    public final List<DomainInfo> domainNames() {
        return this.domainNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainNames() ? this.domainNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainNamesResponse)) {
            return false;
        }
        ListDomainNamesResponse other = (ListDomainNamesResponse)((Object)obj);
        return this.hasDomainNames() == other.hasDomainNames() && Objects.equals(this.domainNames(), other.domainNames());
    }

    public final String toString() {
        return ToString.builder((String)"ListDomainNamesResponse").add("DomainNames", this.hasDomainNames() ? this.domainNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainNames": {
                return Optional.ofNullable(clazz.cast(this.domainNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListDomainNamesResponse, T> g) {
        return obj -> g.apply((ListDomainNamesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticsearchResponse.BuilderImpl
    implements Builder {
        private List<DomainInfo> domainNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainNamesResponse model) {
            super(model);
            this.domainNames(model.domainNames);
        }

        public final List<DomainInfo.Builder> getDomainNames() {
            List<DomainInfo.Builder> result = DomainInfoListCopier.copyToBuilder(this.domainNames);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainNames(Collection<DomainInfo.BuilderImpl> domainNames) {
            this.domainNames = DomainInfoListCopier.copyFromBuilder(domainNames);
        }

        @Override
        public final Builder domainNames(Collection<DomainInfo> domainNames) {
            this.domainNames = DomainInfoListCopier.copy(domainNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainNames(DomainInfo ... domainNames) {
            this.domainNames(Arrays.asList(domainNames));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainNames(Consumer<DomainInfo.Builder> ... domainNames) {
            this.domainNames(Stream.of(domainNames).map(c -> (DomainInfo)((DomainInfo.Builder)DomainInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListDomainNamesResponse build() {
            return new ListDomainNamesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElasticsearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDomainNamesResponse> {
        public Builder domainNames(Collection<DomainInfo> var1);

        public Builder domainNames(DomainInfo ... var1);

        public Builder domainNames(Consumer<DomainInfo.Builder> ... var1);
    }
}

