/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticsearch.model.VpcEndpointErrorCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcEndpointError
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcEndpointError> {
    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcEndpointId").getter(VpcEndpointError.getter(VpcEndpointError::vpcEndpointId)).setter(VpcEndpointError.setter(Builder::vpcEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointId").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorCode").getter(VpcEndpointError.getter(VpcEndpointError::errorCodeAsString)).setter(VpcEndpointError.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(VpcEndpointError.getter(VpcEndpointError::errorMessage)).setter(VpcEndpointError.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ENDPOINT_ID_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("VpcEndpointId", VPC_ENDPOINT_ID_FIELD);
            this.put("ErrorCode", ERROR_CODE_FIELD);
            this.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String vpcEndpointId;
    private final String errorCode;
    private final String errorMessage;

    private VpcEndpointError(BuilderImpl builder) {
        this.vpcEndpointId = builder.vpcEndpointId;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    public final String vpcEndpointId() {
        return this.vpcEndpointId;
    }

    public final VpcEndpointErrorCode errorCode() {
        return VpcEndpointErrorCode.fromValue(this.errorCode);
    }

    public final String errorCodeAsString() {
        return this.errorCode;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcEndpointError)) {
            return false;
        }
        VpcEndpointError other = (VpcEndpointError)obj;
        return Objects.equals(this.vpcEndpointId(), other.vpcEndpointId()) && Objects.equals(this.errorCodeAsString(), other.errorCodeAsString()) && Objects.equals(this.errorMessage(), other.errorMessage());
    }

    public final String toString() {
        return ToString.builder((String)"VpcEndpointError").add("VpcEndpointId", (Object)this.vpcEndpointId()).add("ErrorCode", (Object)this.errorCodeAsString()).add("ErrorMessage", (Object)this.errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcEndpointId": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointId()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCodeAsString()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VpcEndpointError, T> g) {
        return obj -> g.apply((VpcEndpointError)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vpcEndpointId;
        private String errorCode;
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcEndpointError model) {
            this.vpcEndpointId(model.vpcEndpointId);
            this.errorCode(model.errorCode);
            this.errorMessage(model.errorMessage);
        }

        public final String getVpcEndpointId() {
            return this.vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(VpcEndpointErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public VpcEndpointError build() {
            return new VpcEndpointError(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcEndpointError> {
        public Builder vpcEndpointId(String var1);

        public Builder errorCode(String var1);

        public Builder errorCode(VpcEndpointErrorCode var1);

        public Builder errorMessage(String var1);
    }
}

