/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PurchaseReservedElasticsearchInstanceOfferingRequest
extends ElasticsearchRequest
implements ToCopyableBuilder<Builder, PurchaseReservedElasticsearchInstanceOfferingRequest> {
    private static final SdkField<String> RESERVED_ELASTICSEARCH_INSTANCE_OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedElasticsearchInstanceOfferingId").getter(PurchaseReservedElasticsearchInstanceOfferingRequest.getter(PurchaseReservedElasticsearchInstanceOfferingRequest::reservedElasticsearchInstanceOfferingId)).setter(PurchaseReservedElasticsearchInstanceOfferingRequest.setter(Builder::reservedElasticsearchInstanceOfferingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedElasticsearchInstanceOfferingId").build()}).build();
    private static final SdkField<String> RESERVATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservationName").getter(PurchaseReservedElasticsearchInstanceOfferingRequest.getter(PurchaseReservedElasticsearchInstanceOfferingRequest::reservationName)).setter(PurchaseReservedElasticsearchInstanceOfferingRequest.setter(Builder::reservationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationName").build()}).build();
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceCount").getter(PurchaseReservedElasticsearchInstanceOfferingRequest.getter(PurchaseReservedElasticsearchInstanceOfferingRequest::instanceCount)).setter(PurchaseReservedElasticsearchInstanceOfferingRequest.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_ELASTICSEARCH_INSTANCE_OFFERING_ID_FIELD, RESERVATION_NAME_FIELD, INSTANCE_COUNT_FIELD));
    private final String reservedElasticsearchInstanceOfferingId;
    private final String reservationName;
    private final Integer instanceCount;

    private PurchaseReservedElasticsearchInstanceOfferingRequest(BuilderImpl builder) {
        super(builder);
        this.reservedElasticsearchInstanceOfferingId = builder.reservedElasticsearchInstanceOfferingId;
        this.reservationName = builder.reservationName;
        this.instanceCount = builder.instanceCount;
    }

    public final String reservedElasticsearchInstanceOfferingId() {
        return this.reservedElasticsearchInstanceOfferingId;
    }

    public final String reservationName() {
        return this.reservationName;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedElasticsearchInstanceOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseReservedElasticsearchInstanceOfferingRequest)) {
            return false;
        }
        PurchaseReservedElasticsearchInstanceOfferingRequest other = (PurchaseReservedElasticsearchInstanceOfferingRequest)((Object)obj);
        return Objects.equals(this.reservedElasticsearchInstanceOfferingId(), other.reservedElasticsearchInstanceOfferingId()) && Objects.equals(this.reservationName(), other.reservationName()) && Objects.equals(this.instanceCount(), other.instanceCount());
    }

    public final String toString() {
        return ToString.builder((String)"PurchaseReservedElasticsearchInstanceOfferingRequest").add("ReservedElasticsearchInstanceOfferingId", (Object)this.reservedElasticsearchInstanceOfferingId()).add("ReservationName", (Object)this.reservationName()).add("InstanceCount", (Object)this.instanceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedElasticsearchInstanceOfferingId": {
                return Optional.ofNullable(clazz.cast(this.reservedElasticsearchInstanceOfferingId()));
            }
            case "ReservationName": {
                return Optional.ofNullable(clazz.cast(this.reservationName()));
            }
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PurchaseReservedElasticsearchInstanceOfferingRequest, T> g) {
        return obj -> g.apply((PurchaseReservedElasticsearchInstanceOfferingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticsearchRequest.BuilderImpl
    implements Builder {
        private String reservedElasticsearchInstanceOfferingId;
        private String reservationName;
        private Integer instanceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseReservedElasticsearchInstanceOfferingRequest model) {
            super(model);
            this.reservedElasticsearchInstanceOfferingId(model.reservedElasticsearchInstanceOfferingId);
            this.reservationName(model.reservationName);
            this.instanceCount(model.instanceCount);
        }

        public final String getReservedElasticsearchInstanceOfferingId() {
            return this.reservedElasticsearchInstanceOfferingId;
        }

        public final void setReservedElasticsearchInstanceOfferingId(String reservedElasticsearchInstanceOfferingId) {
            this.reservedElasticsearchInstanceOfferingId = reservedElasticsearchInstanceOfferingId;
        }

        @Override
        public final Builder reservedElasticsearchInstanceOfferingId(String reservedElasticsearchInstanceOfferingId) {
            this.reservedElasticsearchInstanceOfferingId = reservedElasticsearchInstanceOfferingId;
            return this;
        }

        public final String getReservationName() {
            return this.reservationName;
        }

        public final void setReservationName(String reservationName) {
            this.reservationName = reservationName;
        }

        @Override
        public final Builder reservationName(String reservationName) {
            this.reservationName = reservationName;
            return this;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PurchaseReservedElasticsearchInstanceOfferingRequest build() {
            return new PurchaseReservedElasticsearchInstanceOfferingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticsearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PurchaseReservedElasticsearchInstanceOfferingRequest> {
        public Builder reservedElasticsearchInstanceOfferingId(String var1);

        public Builder reservationName(String var1);

        public Builder instanceCount(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

