/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>PurchaseReservedElasticsearchInstanceOffering</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PurchaseReservedElasticsearchInstanceOfferingResponse extends ElasticsearchResponse
        implements
        ToCopyableBuilder<PurchaseReservedElasticsearchInstanceOfferingResponse.Builder, PurchaseReservedElasticsearchInstanceOfferingResponse> {
    private static final SdkField<String> RESERVED_ELASTICSEARCH_INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReservedElasticsearchInstanceId")
            .getter(getter(PurchaseReservedElasticsearchInstanceOfferingResponse::reservedElasticsearchInstanceId))
            .setter(setter(Builder::reservedElasticsearchInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedElasticsearchInstanceId")
                    .build()).build();

    private static final SdkField<String> RESERVATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReservationName").getter(getter(PurchaseReservedElasticsearchInstanceOfferingResponse::reservationName))
            .setter(setter(Builder::reservationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESERVED_ELASTICSEARCH_INSTANCE_ID_FIELD, RESERVATION_NAME_FIELD));

    private final String reservedElasticsearchInstanceId;

    private final String reservationName;

    private PurchaseReservedElasticsearchInstanceOfferingResponse(BuilderImpl builder) {
        super(builder);
        this.reservedElasticsearchInstanceId = builder.reservedElasticsearchInstanceId;
        this.reservationName = builder.reservationName;
    }

    /**
     * <p>
     * Details of the reserved Elasticsearch instance which was purchased.
     * </p>
     * 
     * @return Details of the reserved Elasticsearch instance which was purchased.
     */
    public final String reservedElasticsearchInstanceId() {
        return reservedElasticsearchInstanceId;
    }

    /**
     * <p>
     * The customer-specified identifier used to track this reservation.
     * </p>
     * 
     * @return The customer-specified identifier used to track this reservation.
     */
    public final String reservationName() {
        return reservationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reservedElasticsearchInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(reservationName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseReservedElasticsearchInstanceOfferingResponse)) {
            return false;
        }
        PurchaseReservedElasticsearchInstanceOfferingResponse other = (PurchaseReservedElasticsearchInstanceOfferingResponse) obj;
        return Objects.equals(reservedElasticsearchInstanceId(), other.reservedElasticsearchInstanceId())
                && Objects.equals(reservationName(), other.reservationName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PurchaseReservedElasticsearchInstanceOfferingResponse")
                .add("ReservedElasticsearchInstanceId", reservedElasticsearchInstanceId())
                .add("ReservationName", reservationName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedElasticsearchInstanceId":
            return Optional.ofNullable(clazz.cast(reservedElasticsearchInstanceId()));
        case "ReservationName":
            return Optional.ofNullable(clazz.cast(reservationName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PurchaseReservedElasticsearchInstanceOfferingResponse, T> g) {
        return obj -> g.apply((PurchaseReservedElasticsearchInstanceOfferingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticsearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PurchaseReservedElasticsearchInstanceOfferingResponse> {
        /**
         * <p>
         * Details of the reserved Elasticsearch instance which was purchased.
         * </p>
         * 
         * @param reservedElasticsearchInstanceId
         *        Details of the reserved Elasticsearch instance which was purchased.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedElasticsearchInstanceId(String reservedElasticsearchInstanceId);

        /**
         * <p>
         * The customer-specified identifier used to track this reservation.
         * </p>
         * 
         * @param reservationName
         *        The customer-specified identifier used to track this reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservationName(String reservationName);
    }

    static final class BuilderImpl extends ElasticsearchResponse.BuilderImpl implements Builder {
        private String reservedElasticsearchInstanceId;

        private String reservationName;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseReservedElasticsearchInstanceOfferingResponse model) {
            super(model);
            reservedElasticsearchInstanceId(model.reservedElasticsearchInstanceId);
            reservationName(model.reservationName);
        }

        public final String getReservedElasticsearchInstanceId() {
            return reservedElasticsearchInstanceId;
        }

        public final void setReservedElasticsearchInstanceId(String reservedElasticsearchInstanceId) {
            this.reservedElasticsearchInstanceId = reservedElasticsearchInstanceId;
        }

        @Override
        public final Builder reservedElasticsearchInstanceId(String reservedElasticsearchInstanceId) {
            this.reservedElasticsearchInstanceId = reservedElasticsearchInstanceId;
            return this;
        }

        public final String getReservationName() {
            return reservationName;
        }

        public final void setReservationName(String reservationName) {
            this.reservationName = reservationName;
        }

        @Override
        public final Builder reservationName(String reservationName) {
            this.reservationName = reservationName;
            return this;
        }

        @Override
        public PurchaseReservedElasticsearchInstanceOfferingResponse build() {
            return new PurchaseReservedElasticsearchInstanceOfferingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
