/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchClient;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsResponse;

public class ListElasticsearchVersionsIterable
implements SdkIterable<ListElasticsearchVersionsResponse> {
    private final ElasticsearchClient client;
    private final ListElasticsearchVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListElasticsearchVersionsIterable(ElasticsearchClient client, ListElasticsearchVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListElasticsearchVersionsResponseFetcher();
    }

    public Iterator<ListElasticsearchVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListElasticsearchVersionsResponseFetcher
    implements SyncPageFetcher<ListElasticsearchVersionsResponse> {
        private ListElasticsearchVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListElasticsearchVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListElasticsearchVersionsResponse nextPage(ListElasticsearchVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListElasticsearchVersionsIterable.this.client.listElasticsearchVersions(ListElasticsearchVersionsIterable.this.firstRequest);
            }
            return ListElasticsearchVersionsIterable.this.client.listElasticsearchVersions((ListElasticsearchVersionsRequest)((Object)ListElasticsearchVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

