/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchResponse;
import software.amazon.awssdk.services.elasticsearch.model.PackageVersionHistory;
import software.amazon.awssdk.services.elasticsearch.model.PackageVersionHistoryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPackageVersionHistoryResponse
extends ElasticsearchResponse
implements ToCopyableBuilder<Builder, GetPackageVersionHistoryResponse> {
    private static final SdkField<String> PACKAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageID").getter(GetPackageVersionHistoryResponse.getter(GetPackageVersionHistoryResponse::packageID)).setter(GetPackageVersionHistoryResponse.setter(Builder::packageID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageID").build()}).build();
    private static final SdkField<List<PackageVersionHistory>> PACKAGE_VERSION_HISTORY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PackageVersionHistoryList").getter(GetPackageVersionHistoryResponse.getter(GetPackageVersionHistoryResponse::packageVersionHistoryList)).setter(GetPackageVersionHistoryResponse.setter(Builder::packageVersionHistoryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageVersionHistoryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PackageVersionHistory::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetPackageVersionHistoryResponse.getter(GetPackageVersionHistoryResponse::nextToken)).setter(GetPackageVersionHistoryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_ID_FIELD, PACKAGE_VERSION_HISTORY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final String packageID;
    private final List<PackageVersionHistory> packageVersionHistoryList;
    private final String nextToken;

    private GetPackageVersionHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.packageID = builder.packageID;
        this.packageVersionHistoryList = builder.packageVersionHistoryList;
        this.nextToken = builder.nextToken;
    }

    public final String packageID() {
        return this.packageID;
    }

    public final boolean hasPackageVersionHistoryList() {
        return this.packageVersionHistoryList != null && !(this.packageVersionHistoryList instanceof SdkAutoConstructList);
    }

    public final List<PackageVersionHistory> packageVersionHistoryList() {
        return this.packageVersionHistoryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.packageID());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPackageVersionHistoryList() ? this.packageVersionHistoryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPackageVersionHistoryResponse)) {
            return false;
        }
        GetPackageVersionHistoryResponse other = (GetPackageVersionHistoryResponse)((Object)obj);
        return Objects.equals(this.packageID(), other.packageID()) && this.hasPackageVersionHistoryList() == other.hasPackageVersionHistoryList() && Objects.equals(this.packageVersionHistoryList(), other.packageVersionHistoryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetPackageVersionHistoryResponse").add("PackageID", (Object)this.packageID()).add("PackageVersionHistoryList", this.hasPackageVersionHistoryList() ? this.packageVersionHistoryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PackageID": {
                return Optional.ofNullable(clazz.cast(this.packageID()));
            }
            case "PackageVersionHistoryList": {
                return Optional.ofNullable(clazz.cast(this.packageVersionHistoryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPackageVersionHistoryResponse, T> g) {
        return obj -> g.apply((GetPackageVersionHistoryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticsearchResponse.BuilderImpl
    implements Builder {
        private String packageID;
        private List<PackageVersionHistory> packageVersionHistoryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPackageVersionHistoryResponse model) {
            super(model);
            this.packageID(model.packageID);
            this.packageVersionHistoryList(model.packageVersionHistoryList);
            this.nextToken(model.nextToken);
        }

        public final String getPackageID() {
            return this.packageID;
        }

        @Override
        public final Builder packageID(String packageID) {
            this.packageID = packageID;
            return this;
        }

        public final void setPackageID(String packageID) {
            this.packageID = packageID;
        }

        public final List<PackageVersionHistory.Builder> getPackageVersionHistoryList() {
            List<PackageVersionHistory.Builder> result = PackageVersionHistoryListCopier.copyToBuilder(this.packageVersionHistoryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder packageVersionHistoryList(Collection<PackageVersionHistory> packageVersionHistoryList) {
            this.packageVersionHistoryList = PackageVersionHistoryListCopier.copy(packageVersionHistoryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packageVersionHistoryList(PackageVersionHistory ... packageVersionHistoryList) {
            this.packageVersionHistoryList(Arrays.asList(packageVersionHistoryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packageVersionHistoryList(Consumer<PackageVersionHistory.Builder> ... packageVersionHistoryList) {
            this.packageVersionHistoryList(Stream.of(packageVersionHistoryList).map(c -> (PackageVersionHistory)((PackageVersionHistory.Builder)PackageVersionHistory.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPackageVersionHistoryList(Collection<PackageVersionHistory.BuilderImpl> packageVersionHistoryList) {
            this.packageVersionHistoryList = PackageVersionHistoryListCopier.copyFromBuilder(packageVersionHistoryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetPackageVersionHistoryResponse build() {
            return new GetPackageVersionHistoryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticsearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPackageVersionHistoryResponse> {
        public Builder packageID(String var1);

        public Builder packageVersionHistoryList(Collection<PackageVersionHistory> var1);

        public Builder packageVersionHistoryList(PackageVersionHistory ... var1);

        public Builder packageVersionHistoryList(Consumer<PackageVersionHistory.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

