/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for response returned by <code> <a>DescribePackages</a> </code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePackagesResponse extends ElasticsearchResponse implements
        ToCopyableBuilder<DescribePackagesResponse.Builder, DescribePackagesResponse> {
    private static final SdkField<List<PackageDetails>> PACKAGE_DETAILS_LIST_FIELD = SdkField
            .<List<PackageDetails>> builder(MarshallingType.LIST)
            .memberName("PackageDetailsList")
            .getter(getter(DescribePackagesResponse::packageDetailsList))
            .setter(setter(Builder::packageDetailsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageDetailsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PackageDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(PackageDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribePackagesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_DETAILS_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<PackageDetails> packageDetailsList;

    private final String nextToken;

    private DescribePackagesResponse(BuilderImpl builder) {
        super(builder);
        this.packageDetailsList = builder.packageDetailsList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the PackageDetailsList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPackageDetailsList() {
        return packageDetailsList != null && !(packageDetailsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of <code>PackageDetails</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPackageDetailsList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of <code>PackageDetails</code> objects.
     */
    public final List<PackageDetails> packageDetailsList() {
        return packageDetailsList;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPackageDetailsList() ? packageDetailsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePackagesResponse)) {
            return false;
        }
        DescribePackagesResponse other = (DescribePackagesResponse) obj;
        return hasPackageDetailsList() == other.hasPackageDetailsList()
                && Objects.equals(packageDetailsList(), other.packageDetailsList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePackagesResponse")
                .add("PackageDetailsList", hasPackageDetailsList() ? packageDetailsList() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PackageDetailsList":
            return Optional.ofNullable(clazz.cast(packageDetailsList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePackagesResponse, T> g) {
        return obj -> g.apply((DescribePackagesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticsearchResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribePackagesResponse> {
        /**
         * <p>
         * List of <code>PackageDetails</code> objects.
         * </p>
         * 
         * @param packageDetailsList
         *        List of <code>PackageDetails</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageDetailsList(Collection<PackageDetails> packageDetailsList);

        /**
         * <p>
         * List of <code>PackageDetails</code> objects.
         * </p>
         * 
         * @param packageDetailsList
         *        List of <code>PackageDetails</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageDetailsList(PackageDetails... packageDetailsList);

        /**
         * <p>
         * List of <code>PackageDetails</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PackageDetails>.Builder} avoiding the need
         * to create one manually via {@link List<PackageDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PackageDetails>.Builder#build()} is called immediately and
         * its result is passed to {@link #packageDetailsList(List<PackageDetails>)}.
         * 
         * @param packageDetailsList
         *        a consumer that will call methods on {@link List<PackageDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packageDetailsList(List<PackageDetails>)
         */
        Builder packageDetailsList(Consumer<PackageDetails.Builder>... packageDetailsList);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ElasticsearchResponse.BuilderImpl implements Builder {
        private List<PackageDetails> packageDetailsList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePackagesResponse model) {
            super(model);
            packageDetailsList(model.packageDetailsList);
            nextToken(model.nextToken);
        }

        public final Collection<PackageDetails.Builder> getPackageDetailsList() {
            if (packageDetailsList instanceof SdkAutoConstructList) {
                return null;
            }
            return packageDetailsList != null ? packageDetailsList.stream().map(PackageDetails::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder packageDetailsList(Collection<PackageDetails> packageDetailsList) {
            this.packageDetailsList = PackageDetailsListCopier.copy(packageDetailsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packageDetailsList(PackageDetails... packageDetailsList) {
            packageDetailsList(Arrays.asList(packageDetailsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packageDetailsList(Consumer<PackageDetails.Builder>... packageDetailsList) {
            packageDetailsList(Stream.of(packageDetailsList).map(c -> PackageDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPackageDetailsList(Collection<PackageDetails.BuilderImpl> packageDetailsList) {
            this.packageDetailsList = PackageDetailsListCopier.copyFromBuilder(packageDetailsList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribePackagesResponse build() {
            return new DescribePackagesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
