/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SAMLIdp
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SAMLIdp> {
    private static final SdkField<String> METADATA_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetadataContent").getter(SAMLIdp.getter(SAMLIdp::metadataContent)).setter(SAMLIdp.setter(Builder::metadataContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataContent").build()}).build();
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityId").getter(SAMLIdp.getter(SAMLIdp::entityId)).setter(SAMLIdp.setter(Builder::entityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_CONTENT_FIELD, ENTITY_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String metadataContent;
    private final String entityId;

    private SAMLIdp(BuilderImpl builder) {
        this.metadataContent = builder.metadataContent;
        this.entityId = builder.entityId;
    }

    public String metadataContent() {
        return this.metadataContent;
    }

    public String entityId() {
        return this.entityId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SAMLIdp)) {
            return false;
        }
        SAMLIdp other = (SAMLIdp)obj;
        return Objects.equals(this.metadataContent(), other.metadataContent()) && Objects.equals(this.entityId(), other.entityId());
    }

    public String toString() {
        return ToString.builder((String)"SAMLIdp").add("MetadataContent", (Object)this.metadataContent()).add("EntityId", (Object)this.entityId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetadataContent": {
                return Optional.ofNullable(clazz.cast(this.metadataContent()));
            }
            case "EntityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SAMLIdp, T> g) {
        return obj -> g.apply((SAMLIdp)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metadataContent;
        private String entityId;

        private BuilderImpl() {
        }

        private BuilderImpl(SAMLIdp model) {
            this.metadataContent(model.metadataContent);
            this.entityId(model.entityId);
        }

        public final String getMetadataContent() {
            return this.metadataContent;
        }

        @Override
        public final Builder metadataContent(String metadataContent) {
            this.metadataContent = metadataContent;
            return this;
        }

        public final void setMetadataContent(String metadataContent) {
            this.metadataContent = metadataContent;
        }

        public final String getEntityId() {
            return this.entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public SAMLIdp build() {
            return new SAMLIdp(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SAMLIdp> {
        public Builder metadataContent(String var1);

        public Builder entityId(String var1);
    }
}

