/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticsearch.model.AccessPoliciesStatus;
import software.amazon.awssdk.services.elasticsearch.model.AdvancedOptionsStatus;
import software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptionsStatus;
import software.amazon.awssdk.services.elasticsearch.model.CognitoOptionsStatus;
import software.amazon.awssdk.services.elasticsearch.model.DomainEndpointOptionsStatus;
import software.amazon.awssdk.services.elasticsearch.model.EBSOptionsStatus;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchClusterConfigStatus;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchVersionStatus;
import software.amazon.awssdk.services.elasticsearch.model.EncryptionAtRestOptionsStatus;
import software.amazon.awssdk.services.elasticsearch.model.LogPublishingOptionsStatus;
import software.amazon.awssdk.services.elasticsearch.model.NodeToNodeEncryptionOptionsStatus;
import software.amazon.awssdk.services.elasticsearch.model.SnapshotOptionsStatus;
import software.amazon.awssdk.services.elasticsearch.model.VPCDerivedInfoStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ElasticsearchDomainConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ElasticsearchDomainConfig> {
    private static final SdkField<ElasticsearchVersionStatus> ELASTICSEARCH_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ElasticsearchDomainConfig.getter(ElasticsearchDomainConfig::elasticsearchVersion)).setter(ElasticsearchDomainConfig.setter(Builder::elasticsearchVersion)).constructor(ElasticsearchVersionStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchVersion").build()}).build();
    private static final SdkField<ElasticsearchClusterConfigStatus> ELASTICSEARCH_CLUSTER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ElasticsearchDomainConfig.getter(ElasticsearchDomainConfig::elasticsearchClusterConfig)).setter(ElasticsearchDomainConfig.setter(Builder::elasticsearchClusterConfig)).constructor(ElasticsearchClusterConfigStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchClusterConfig").build()}).build();
    private static final SdkField<EBSOptionsStatus> EBS_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ElasticsearchDomainConfig.getter(ElasticsearchDomainConfig::ebsOptions)).setter(ElasticsearchDomainConfig.setter(Builder::ebsOptions)).constructor(EBSOptionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EBSOptions").build()}).build();
    private static final SdkField<AccessPoliciesStatus> ACCESS_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ElasticsearchDomainConfig.getter(ElasticsearchDomainConfig::accessPolicies)).setter(ElasticsearchDomainConfig.setter(Builder::accessPolicies)).constructor(AccessPoliciesStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPolicies").build()}).build();
    private static final SdkField<SnapshotOptionsStatus> SNAPSHOT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ElasticsearchDomainConfig.getter(ElasticsearchDomainConfig::snapshotOptions)).setter(ElasticsearchDomainConfig.setter(Builder::snapshotOptions)).constructor(SnapshotOptionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotOptions").build()}).build();
    private static final SdkField<VPCDerivedInfoStatus> VPC_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ElasticsearchDomainConfig.getter(ElasticsearchDomainConfig::vpcOptions)).setter(ElasticsearchDomainConfig.setter(Builder::vpcOptions)).constructor(VPCDerivedInfoStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCOptions").build()}).build();
    private static final SdkField<CognitoOptionsStatus> COGNITO_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ElasticsearchDomainConfig.getter(ElasticsearchDomainConfig::cognitoOptions)).setter(ElasticsearchDomainConfig.setter(Builder::cognitoOptions)).constructor(CognitoOptionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CognitoOptions").build()}).build();
    private static final SdkField<EncryptionAtRestOptionsStatus> ENCRYPTION_AT_REST_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ElasticsearchDomainConfig.getter(ElasticsearchDomainConfig::encryptionAtRestOptions)).setter(ElasticsearchDomainConfig.setter(Builder::encryptionAtRestOptions)).constructor(EncryptionAtRestOptionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAtRestOptions").build()}).build();
    private static final SdkField<NodeToNodeEncryptionOptionsStatus> NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ElasticsearchDomainConfig.getter(ElasticsearchDomainConfig::nodeToNodeEncryptionOptions)).setter(ElasticsearchDomainConfig.setter(Builder::nodeToNodeEncryptionOptions)).constructor(NodeToNodeEncryptionOptionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeToNodeEncryptionOptions").build()}).build();
    private static final SdkField<AdvancedOptionsStatus> ADVANCED_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ElasticsearchDomainConfig.getter(ElasticsearchDomainConfig::advancedOptions)).setter(ElasticsearchDomainConfig.setter(Builder::advancedOptions)).constructor(AdvancedOptionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedOptions").build()}).build();
    private static final SdkField<LogPublishingOptionsStatus> LOG_PUBLISHING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ElasticsearchDomainConfig.getter(ElasticsearchDomainConfig::logPublishingOptions)).setter(ElasticsearchDomainConfig.setter(Builder::logPublishingOptions)).constructor(LogPublishingOptionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPublishingOptions").build()}).build();
    private static final SdkField<DomainEndpointOptionsStatus> DOMAIN_ENDPOINT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ElasticsearchDomainConfig.getter(ElasticsearchDomainConfig::domainEndpointOptions)).setter(ElasticsearchDomainConfig.setter(Builder::domainEndpointOptions)).constructor(DomainEndpointOptionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainEndpointOptions").build()}).build();
    private static final SdkField<AdvancedSecurityOptionsStatus> ADVANCED_SECURITY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ElasticsearchDomainConfig.getter(ElasticsearchDomainConfig::advancedSecurityOptions)).setter(ElasticsearchDomainConfig.setter(Builder::advancedSecurityOptions)).constructor(AdvancedSecurityOptionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedSecurityOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELASTICSEARCH_VERSION_FIELD, ELASTICSEARCH_CLUSTER_CONFIG_FIELD, EBS_OPTIONS_FIELD, ACCESS_POLICIES_FIELD, SNAPSHOT_OPTIONS_FIELD, VPC_OPTIONS_FIELD, COGNITO_OPTIONS_FIELD, ENCRYPTION_AT_REST_OPTIONS_FIELD, NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD, ADVANCED_OPTIONS_FIELD, LOG_PUBLISHING_OPTIONS_FIELD, DOMAIN_ENDPOINT_OPTIONS_FIELD, ADVANCED_SECURITY_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final ElasticsearchVersionStatus elasticsearchVersion;
    private final ElasticsearchClusterConfigStatus elasticsearchClusterConfig;
    private final EBSOptionsStatus ebsOptions;
    private final AccessPoliciesStatus accessPolicies;
    private final SnapshotOptionsStatus snapshotOptions;
    private final VPCDerivedInfoStatus vpcOptions;
    private final CognitoOptionsStatus cognitoOptions;
    private final EncryptionAtRestOptionsStatus encryptionAtRestOptions;
    private final NodeToNodeEncryptionOptionsStatus nodeToNodeEncryptionOptions;
    private final AdvancedOptionsStatus advancedOptions;
    private final LogPublishingOptionsStatus logPublishingOptions;
    private final DomainEndpointOptionsStatus domainEndpointOptions;
    private final AdvancedSecurityOptionsStatus advancedSecurityOptions;

    private ElasticsearchDomainConfig(BuilderImpl builder) {
        this.elasticsearchVersion = builder.elasticsearchVersion;
        this.elasticsearchClusterConfig = builder.elasticsearchClusterConfig;
        this.ebsOptions = builder.ebsOptions;
        this.accessPolicies = builder.accessPolicies;
        this.snapshotOptions = builder.snapshotOptions;
        this.vpcOptions = builder.vpcOptions;
        this.cognitoOptions = builder.cognitoOptions;
        this.encryptionAtRestOptions = builder.encryptionAtRestOptions;
        this.nodeToNodeEncryptionOptions = builder.nodeToNodeEncryptionOptions;
        this.advancedOptions = builder.advancedOptions;
        this.logPublishingOptions = builder.logPublishingOptions;
        this.domainEndpointOptions = builder.domainEndpointOptions;
        this.advancedSecurityOptions = builder.advancedSecurityOptions;
    }

    public ElasticsearchVersionStatus elasticsearchVersion() {
        return this.elasticsearchVersion;
    }

    public ElasticsearchClusterConfigStatus elasticsearchClusterConfig() {
        return this.elasticsearchClusterConfig;
    }

    public EBSOptionsStatus ebsOptions() {
        return this.ebsOptions;
    }

    public AccessPoliciesStatus accessPolicies() {
        return this.accessPolicies;
    }

    public SnapshotOptionsStatus snapshotOptions() {
        return this.snapshotOptions;
    }

    public VPCDerivedInfoStatus vpcOptions() {
        return this.vpcOptions;
    }

    public CognitoOptionsStatus cognitoOptions() {
        return this.cognitoOptions;
    }

    public EncryptionAtRestOptionsStatus encryptionAtRestOptions() {
        return this.encryptionAtRestOptions;
    }

    public NodeToNodeEncryptionOptionsStatus nodeToNodeEncryptionOptions() {
        return this.nodeToNodeEncryptionOptions;
    }

    public AdvancedOptionsStatus advancedOptions() {
        return this.advancedOptions;
    }

    public LogPublishingOptionsStatus logPublishingOptions() {
        return this.logPublishingOptions;
    }

    public DomainEndpointOptionsStatus domainEndpointOptions() {
        return this.domainEndpointOptions;
    }

    public AdvancedSecurityOptionsStatus advancedSecurityOptions() {
        return this.advancedSecurityOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchClusterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.cognitoOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionAtRestOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeToNodeEncryptionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.advancedOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.logPublishingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainEndpointOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.advancedSecurityOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchDomainConfig)) {
            return false;
        }
        ElasticsearchDomainConfig other = (ElasticsearchDomainConfig)obj;
        return Objects.equals(this.elasticsearchVersion(), other.elasticsearchVersion()) && Objects.equals(this.elasticsearchClusterConfig(), other.elasticsearchClusterConfig()) && Objects.equals(this.ebsOptions(), other.ebsOptions()) && Objects.equals(this.accessPolicies(), other.accessPolicies()) && Objects.equals(this.snapshotOptions(), other.snapshotOptions()) && Objects.equals(this.vpcOptions(), other.vpcOptions()) && Objects.equals(this.cognitoOptions(), other.cognitoOptions()) && Objects.equals(this.encryptionAtRestOptions(), other.encryptionAtRestOptions()) && Objects.equals(this.nodeToNodeEncryptionOptions(), other.nodeToNodeEncryptionOptions()) && Objects.equals(this.advancedOptions(), other.advancedOptions()) && Objects.equals(this.logPublishingOptions(), other.logPublishingOptions()) && Objects.equals(this.domainEndpointOptions(), other.domainEndpointOptions()) && Objects.equals(this.advancedSecurityOptions(), other.advancedSecurityOptions());
    }

    public String toString() {
        return ToString.builder((String)"ElasticsearchDomainConfig").add("ElasticsearchVersion", (Object)this.elasticsearchVersion()).add("ElasticsearchClusterConfig", (Object)this.elasticsearchClusterConfig()).add("EBSOptions", (Object)this.ebsOptions()).add("AccessPolicies", (Object)this.accessPolicies()).add("SnapshotOptions", (Object)this.snapshotOptions()).add("VPCOptions", (Object)this.vpcOptions()).add("CognitoOptions", (Object)this.cognitoOptions()).add("EncryptionAtRestOptions", (Object)this.encryptionAtRestOptions()).add("NodeToNodeEncryptionOptions", (Object)this.nodeToNodeEncryptionOptions()).add("AdvancedOptions", (Object)this.advancedOptions()).add("LogPublishingOptions", (Object)this.logPublishingOptions()).add("DomainEndpointOptions", (Object)this.domainEndpointOptions()).add("AdvancedSecurityOptions", (Object)this.advancedSecurityOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ElasticsearchVersion": {
                return Optional.ofNullable(clazz.cast(this.elasticsearchVersion()));
            }
            case "ElasticsearchClusterConfig": {
                return Optional.ofNullable(clazz.cast(this.elasticsearchClusterConfig()));
            }
            case "EBSOptions": {
                return Optional.ofNullable(clazz.cast(this.ebsOptions()));
            }
            case "AccessPolicies": {
                return Optional.ofNullable(clazz.cast(this.accessPolicies()));
            }
            case "SnapshotOptions": {
                return Optional.ofNullable(clazz.cast(this.snapshotOptions()));
            }
            case "VPCOptions": {
                return Optional.ofNullable(clazz.cast(this.vpcOptions()));
            }
            case "CognitoOptions": {
                return Optional.ofNullable(clazz.cast(this.cognitoOptions()));
            }
            case "EncryptionAtRestOptions": {
                return Optional.ofNullable(clazz.cast(this.encryptionAtRestOptions()));
            }
            case "NodeToNodeEncryptionOptions": {
                return Optional.ofNullable(clazz.cast(this.nodeToNodeEncryptionOptions()));
            }
            case "AdvancedOptions": {
                return Optional.ofNullable(clazz.cast(this.advancedOptions()));
            }
            case "LogPublishingOptions": {
                return Optional.ofNullable(clazz.cast(this.logPublishingOptions()));
            }
            case "DomainEndpointOptions": {
                return Optional.ofNullable(clazz.cast(this.domainEndpointOptions()));
            }
            case "AdvancedSecurityOptions": {
                return Optional.ofNullable(clazz.cast(this.advancedSecurityOptions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ElasticsearchDomainConfig, T> g) {
        return obj -> g.apply((ElasticsearchDomainConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ElasticsearchVersionStatus elasticsearchVersion;
        private ElasticsearchClusterConfigStatus elasticsearchClusterConfig;
        private EBSOptionsStatus ebsOptions;
        private AccessPoliciesStatus accessPolicies;
        private SnapshotOptionsStatus snapshotOptions;
        private VPCDerivedInfoStatus vpcOptions;
        private CognitoOptionsStatus cognitoOptions;
        private EncryptionAtRestOptionsStatus encryptionAtRestOptions;
        private NodeToNodeEncryptionOptionsStatus nodeToNodeEncryptionOptions;
        private AdvancedOptionsStatus advancedOptions;
        private LogPublishingOptionsStatus logPublishingOptions;
        private DomainEndpointOptionsStatus domainEndpointOptions;
        private AdvancedSecurityOptionsStatus advancedSecurityOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchDomainConfig model) {
            this.elasticsearchVersion(model.elasticsearchVersion);
            this.elasticsearchClusterConfig(model.elasticsearchClusterConfig);
            this.ebsOptions(model.ebsOptions);
            this.accessPolicies(model.accessPolicies);
            this.snapshotOptions(model.snapshotOptions);
            this.vpcOptions(model.vpcOptions);
            this.cognitoOptions(model.cognitoOptions);
            this.encryptionAtRestOptions(model.encryptionAtRestOptions);
            this.nodeToNodeEncryptionOptions(model.nodeToNodeEncryptionOptions);
            this.advancedOptions(model.advancedOptions);
            this.logPublishingOptions(model.logPublishingOptions);
            this.domainEndpointOptions(model.domainEndpointOptions);
            this.advancedSecurityOptions(model.advancedSecurityOptions);
        }

        public final ElasticsearchVersionStatus.Builder getElasticsearchVersion() {
            return this.elasticsearchVersion != null ? this.elasticsearchVersion.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearchVersion(ElasticsearchVersionStatus elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
            return this;
        }

        public final void setElasticsearchVersion(ElasticsearchVersionStatus.BuilderImpl elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion != null ? elasticsearchVersion.build() : null;
        }

        public final ElasticsearchClusterConfigStatus.Builder getElasticsearchClusterConfig() {
            return this.elasticsearchClusterConfig != null ? this.elasticsearchClusterConfig.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearchClusterConfig(ElasticsearchClusterConfigStatus elasticsearchClusterConfig) {
            this.elasticsearchClusterConfig = elasticsearchClusterConfig;
            return this;
        }

        public final void setElasticsearchClusterConfig(ElasticsearchClusterConfigStatus.BuilderImpl elasticsearchClusterConfig) {
            this.elasticsearchClusterConfig = elasticsearchClusterConfig != null ? elasticsearchClusterConfig.build() : null;
        }

        public final EBSOptionsStatus.Builder getEbsOptions() {
            return this.ebsOptions != null ? this.ebsOptions.toBuilder() : null;
        }

        @Override
        public final Builder ebsOptions(EBSOptionsStatus ebsOptions) {
            this.ebsOptions = ebsOptions;
            return this;
        }

        public final void setEbsOptions(EBSOptionsStatus.BuilderImpl ebsOptions) {
            this.ebsOptions = ebsOptions != null ? ebsOptions.build() : null;
        }

        public final AccessPoliciesStatus.Builder getAccessPolicies() {
            return this.accessPolicies != null ? this.accessPolicies.toBuilder() : null;
        }

        @Override
        public final Builder accessPolicies(AccessPoliciesStatus accessPolicies) {
            this.accessPolicies = accessPolicies;
            return this;
        }

        public final void setAccessPolicies(AccessPoliciesStatus.BuilderImpl accessPolicies) {
            this.accessPolicies = accessPolicies != null ? accessPolicies.build() : null;
        }

        public final SnapshotOptionsStatus.Builder getSnapshotOptions() {
            return this.snapshotOptions != null ? this.snapshotOptions.toBuilder() : null;
        }

        @Override
        public final Builder snapshotOptions(SnapshotOptionsStatus snapshotOptions) {
            this.snapshotOptions = snapshotOptions;
            return this;
        }

        public final void setSnapshotOptions(SnapshotOptionsStatus.BuilderImpl snapshotOptions) {
            this.snapshotOptions = snapshotOptions != null ? snapshotOptions.build() : null;
        }

        public final VPCDerivedInfoStatus.Builder getVpcOptions() {
            return this.vpcOptions != null ? this.vpcOptions.toBuilder() : null;
        }

        @Override
        public final Builder vpcOptions(VPCDerivedInfoStatus vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        public final void setVpcOptions(VPCDerivedInfoStatus.BuilderImpl vpcOptions) {
            this.vpcOptions = vpcOptions != null ? vpcOptions.build() : null;
        }

        public final CognitoOptionsStatus.Builder getCognitoOptions() {
            return this.cognitoOptions != null ? this.cognitoOptions.toBuilder() : null;
        }

        @Override
        public final Builder cognitoOptions(CognitoOptionsStatus cognitoOptions) {
            this.cognitoOptions = cognitoOptions;
            return this;
        }

        public final void setCognitoOptions(CognitoOptionsStatus.BuilderImpl cognitoOptions) {
            this.cognitoOptions = cognitoOptions != null ? cognitoOptions.build() : null;
        }

        public final EncryptionAtRestOptionsStatus.Builder getEncryptionAtRestOptions() {
            return this.encryptionAtRestOptions != null ? this.encryptionAtRestOptions.toBuilder() : null;
        }

        @Override
        public final Builder encryptionAtRestOptions(EncryptionAtRestOptionsStatus encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions;
            return this;
        }

        public final void setEncryptionAtRestOptions(EncryptionAtRestOptionsStatus.BuilderImpl encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions != null ? encryptionAtRestOptions.build() : null;
        }

        public final NodeToNodeEncryptionOptionsStatus.Builder getNodeToNodeEncryptionOptions() {
            return this.nodeToNodeEncryptionOptions != null ? this.nodeToNodeEncryptionOptions.toBuilder() : null;
        }

        @Override
        public final Builder nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptionsStatus nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions;
            return this;
        }

        public final void setNodeToNodeEncryptionOptions(NodeToNodeEncryptionOptionsStatus.BuilderImpl nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions != null ? nodeToNodeEncryptionOptions.build() : null;
        }

        public final AdvancedOptionsStatus.Builder getAdvancedOptions() {
            return this.advancedOptions != null ? this.advancedOptions.toBuilder() : null;
        }

        @Override
        public final Builder advancedOptions(AdvancedOptionsStatus advancedOptions) {
            this.advancedOptions = advancedOptions;
            return this;
        }

        public final void setAdvancedOptions(AdvancedOptionsStatus.BuilderImpl advancedOptions) {
            this.advancedOptions = advancedOptions != null ? advancedOptions.build() : null;
        }

        public final LogPublishingOptionsStatus.Builder getLogPublishingOptions() {
            return this.logPublishingOptions != null ? this.logPublishingOptions.toBuilder() : null;
        }

        @Override
        public final Builder logPublishingOptions(LogPublishingOptionsStatus logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions;
            return this;
        }

        public final void setLogPublishingOptions(LogPublishingOptionsStatus.BuilderImpl logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions != null ? logPublishingOptions.build() : null;
        }

        public final DomainEndpointOptionsStatus.Builder getDomainEndpointOptions() {
            return this.domainEndpointOptions != null ? this.domainEndpointOptions.toBuilder() : null;
        }

        @Override
        public final Builder domainEndpointOptions(DomainEndpointOptionsStatus domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions;
            return this;
        }

        public final void setDomainEndpointOptions(DomainEndpointOptionsStatus.BuilderImpl domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions != null ? domainEndpointOptions.build() : null;
        }

        public final AdvancedSecurityOptionsStatus.Builder getAdvancedSecurityOptions() {
            return this.advancedSecurityOptions != null ? this.advancedSecurityOptions.toBuilder() : null;
        }

        @Override
        public final Builder advancedSecurityOptions(AdvancedSecurityOptionsStatus advancedSecurityOptions) {
            this.advancedSecurityOptions = advancedSecurityOptions;
            return this;
        }

        public final void setAdvancedSecurityOptions(AdvancedSecurityOptionsStatus.BuilderImpl advancedSecurityOptions) {
            this.advancedSecurityOptions = advancedSecurityOptions != null ? advancedSecurityOptions.build() : null;
        }

        public ElasticsearchDomainConfig build() {
            return new ElasticsearchDomainConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ElasticsearchDomainConfig> {
        public Builder elasticsearchVersion(ElasticsearchVersionStatus var1);

        default public Builder elasticsearchVersion(Consumer<ElasticsearchVersionStatus.Builder> elasticsearchVersion) {
            return this.elasticsearchVersion((ElasticsearchVersionStatus)((ElasticsearchVersionStatus.Builder)ElasticsearchVersionStatus.builder().applyMutation(elasticsearchVersion)).build());
        }

        public Builder elasticsearchClusterConfig(ElasticsearchClusterConfigStatus var1);

        default public Builder elasticsearchClusterConfig(Consumer<ElasticsearchClusterConfigStatus.Builder> elasticsearchClusterConfig) {
            return this.elasticsearchClusterConfig((ElasticsearchClusterConfigStatus)((ElasticsearchClusterConfigStatus.Builder)ElasticsearchClusterConfigStatus.builder().applyMutation(elasticsearchClusterConfig)).build());
        }

        public Builder ebsOptions(EBSOptionsStatus var1);

        default public Builder ebsOptions(Consumer<EBSOptionsStatus.Builder> ebsOptions) {
            return this.ebsOptions((EBSOptionsStatus)((EBSOptionsStatus.Builder)EBSOptionsStatus.builder().applyMutation(ebsOptions)).build());
        }

        public Builder accessPolicies(AccessPoliciesStatus var1);

        default public Builder accessPolicies(Consumer<AccessPoliciesStatus.Builder> accessPolicies) {
            return this.accessPolicies((AccessPoliciesStatus)((AccessPoliciesStatus.Builder)AccessPoliciesStatus.builder().applyMutation(accessPolicies)).build());
        }

        public Builder snapshotOptions(SnapshotOptionsStatus var1);

        default public Builder snapshotOptions(Consumer<SnapshotOptionsStatus.Builder> snapshotOptions) {
            return this.snapshotOptions((SnapshotOptionsStatus)((SnapshotOptionsStatus.Builder)SnapshotOptionsStatus.builder().applyMutation(snapshotOptions)).build());
        }

        public Builder vpcOptions(VPCDerivedInfoStatus var1);

        default public Builder vpcOptions(Consumer<VPCDerivedInfoStatus.Builder> vpcOptions) {
            return this.vpcOptions((VPCDerivedInfoStatus)((VPCDerivedInfoStatus.Builder)VPCDerivedInfoStatus.builder().applyMutation(vpcOptions)).build());
        }

        public Builder cognitoOptions(CognitoOptionsStatus var1);

        default public Builder cognitoOptions(Consumer<CognitoOptionsStatus.Builder> cognitoOptions) {
            return this.cognitoOptions((CognitoOptionsStatus)((CognitoOptionsStatus.Builder)CognitoOptionsStatus.builder().applyMutation(cognitoOptions)).build());
        }

        public Builder encryptionAtRestOptions(EncryptionAtRestOptionsStatus var1);

        default public Builder encryptionAtRestOptions(Consumer<EncryptionAtRestOptionsStatus.Builder> encryptionAtRestOptions) {
            return this.encryptionAtRestOptions((EncryptionAtRestOptionsStatus)((EncryptionAtRestOptionsStatus.Builder)EncryptionAtRestOptionsStatus.builder().applyMutation(encryptionAtRestOptions)).build());
        }

        public Builder nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptionsStatus var1);

        default public Builder nodeToNodeEncryptionOptions(Consumer<NodeToNodeEncryptionOptionsStatus.Builder> nodeToNodeEncryptionOptions) {
            return this.nodeToNodeEncryptionOptions((NodeToNodeEncryptionOptionsStatus)((NodeToNodeEncryptionOptionsStatus.Builder)NodeToNodeEncryptionOptionsStatus.builder().applyMutation(nodeToNodeEncryptionOptions)).build());
        }

        public Builder advancedOptions(AdvancedOptionsStatus var1);

        default public Builder advancedOptions(Consumer<AdvancedOptionsStatus.Builder> advancedOptions) {
            return this.advancedOptions((AdvancedOptionsStatus)((AdvancedOptionsStatus.Builder)AdvancedOptionsStatus.builder().applyMutation(advancedOptions)).build());
        }

        public Builder logPublishingOptions(LogPublishingOptionsStatus var1);

        default public Builder logPublishingOptions(Consumer<LogPublishingOptionsStatus.Builder> logPublishingOptions) {
            return this.logPublishingOptions((LogPublishingOptionsStatus)((LogPublishingOptionsStatus.Builder)LogPublishingOptionsStatus.builder().applyMutation(logPublishingOptions)).build());
        }

        public Builder domainEndpointOptions(DomainEndpointOptionsStatus var1);

        default public Builder domainEndpointOptions(Consumer<DomainEndpointOptionsStatus.Builder> domainEndpointOptions) {
            return this.domainEndpointOptions((DomainEndpointOptionsStatus)((DomainEndpointOptionsStatus.Builder)DomainEndpointOptionsStatus.builder().applyMutation(domainEndpointOptions)).build());
        }

        public Builder advancedSecurityOptions(AdvancedSecurityOptionsStatus var1);

        default public Builder advancedSecurityOptions(Consumer<AdvancedSecurityOptionsStatus.Builder> advancedSecurityOptions) {
            return this.advancedSecurityOptions((AdvancedSecurityOptionsStatus)((AdvancedSecurityOptionsStatus.Builder)AdvancedSecurityOptionsStatus.builder().applyMutation(advancedSecurityOptions)).build());
        }
    }
}

