/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticsearch.model.ErrorDetails;
import software.amazon.awssdk.services.elasticsearch.model.PackageStatus;
import software.amazon.awssdk.services.elasticsearch.model.PackageType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PackageDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PackageDetails> {
    private static final SdkField<String> PACKAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PackageDetails.getter(PackageDetails::packageID)).setter(PackageDetails.setter(Builder::packageID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageID").build()}).build();
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PackageDetails.getter(PackageDetails::packageName)).setter(PackageDetails.setter(Builder::packageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageName").build()}).build();
    private static final SdkField<String> PACKAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PackageDetails.getter(PackageDetails::packageTypeAsString)).setter(PackageDetails.setter(Builder::packageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageType").build()}).build();
    private static final SdkField<String> PACKAGE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PackageDetails.getter(PackageDetails::packageDescription)).setter(PackageDetails.setter(Builder::packageDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageDescription").build()}).build();
    private static final SdkField<String> PACKAGE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PackageDetails.getter(PackageDetails::packageStatusAsString)).setter(PackageDetails.setter(Builder::packageStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageStatus").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(PackageDetails.getter(PackageDetails::createdAt)).setter(PackageDetails.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<ErrorDetails> ERROR_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PackageDetails.getter(PackageDetails::errorDetails)).setter(PackageDetails.setter(Builder::errorDetails)).constructor(ErrorDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_ID_FIELD, PACKAGE_NAME_FIELD, PACKAGE_TYPE_FIELD, PACKAGE_DESCRIPTION_FIELD, PACKAGE_STATUS_FIELD, CREATED_AT_FIELD, ERROR_DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String packageID;
    private final String packageName;
    private final String packageType;
    private final String packageDescription;
    private final String packageStatus;
    private final Instant createdAt;
    private final ErrorDetails errorDetails;

    private PackageDetails(BuilderImpl builder) {
        this.packageID = builder.packageID;
        this.packageName = builder.packageName;
        this.packageType = builder.packageType;
        this.packageDescription = builder.packageDescription;
        this.packageStatus = builder.packageStatus;
        this.createdAt = builder.createdAt;
        this.errorDetails = builder.errorDetails;
    }

    public String packageID() {
        return this.packageID;
    }

    public String packageName() {
        return this.packageName;
    }

    public PackageType packageType() {
        return PackageType.fromValue(this.packageType);
    }

    public String packageTypeAsString() {
        return this.packageType;
    }

    public String packageDescription() {
        return this.packageDescription;
    }

    public PackageStatus packageStatus() {
        return PackageStatus.fromValue(this.packageStatus);
    }

    public String packageStatusAsString() {
        return this.packageStatus;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public ErrorDetails errorDetails() {
        return this.errorDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.packageID());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorDetails());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageDetails)) {
            return false;
        }
        PackageDetails other = (PackageDetails)obj;
        return Objects.equals(this.packageID(), other.packageID()) && Objects.equals(this.packageName(), other.packageName()) && Objects.equals(this.packageTypeAsString(), other.packageTypeAsString()) && Objects.equals(this.packageDescription(), other.packageDescription()) && Objects.equals(this.packageStatusAsString(), other.packageStatusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.errorDetails(), other.errorDetails());
    }

    public String toString() {
        return ToString.builder((String)"PackageDetails").add("PackageID", (Object)this.packageID()).add("PackageName", (Object)this.packageName()).add("PackageType", (Object)this.packageTypeAsString()).add("PackageDescription", (Object)this.packageDescription()).add("PackageStatus", (Object)this.packageStatusAsString()).add("CreatedAt", (Object)this.createdAt()).add("ErrorDetails", (Object)this.errorDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PackageID": {
                return Optional.ofNullable(clazz.cast(this.packageID()));
            }
            case "PackageName": {
                return Optional.ofNullable(clazz.cast(this.packageName()));
            }
            case "PackageType": {
                return Optional.ofNullable(clazz.cast(this.packageTypeAsString()));
            }
            case "PackageDescription": {
                return Optional.ofNullable(clazz.cast(this.packageDescription()));
            }
            case "PackageStatus": {
                return Optional.ofNullable(clazz.cast(this.packageStatusAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "ErrorDetails": {
                return Optional.ofNullable(clazz.cast(this.errorDetails()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PackageDetails, T> g) {
        return obj -> g.apply((PackageDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String packageID;
        private String packageName;
        private String packageType;
        private String packageDescription;
        private String packageStatus;
        private Instant createdAt;
        private ErrorDetails errorDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageDetails model) {
            this.packageID(model.packageID);
            this.packageName(model.packageName);
            this.packageType(model.packageType);
            this.packageDescription(model.packageDescription);
            this.packageStatus(model.packageStatus);
            this.createdAt(model.createdAt);
            this.errorDetails(model.errorDetails);
        }

        public final String getPackageID() {
            return this.packageID;
        }

        @Override
        public final Builder packageID(String packageID) {
            this.packageID = packageID;
            return this;
        }

        public final void setPackageID(String packageID) {
            this.packageID = packageID;
        }

        public final String getPackageName() {
            return this.packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public final String getPackageType() {
            return this.packageType;
        }

        @Override
        public final Builder packageType(String packageType) {
            this.packageType = packageType;
            return this;
        }

        @Override
        public final Builder packageType(PackageType packageType) {
            this.packageType(packageType == null ? null : packageType.toString());
            return this;
        }

        public final void setPackageType(String packageType) {
            this.packageType = packageType;
        }

        public final String getPackageDescription() {
            return this.packageDescription;
        }

        @Override
        public final Builder packageDescription(String packageDescription) {
            this.packageDescription = packageDescription;
            return this;
        }

        public final void setPackageDescription(String packageDescription) {
            this.packageDescription = packageDescription;
        }

        public final String getPackageStatus() {
            return this.packageStatus;
        }

        @Override
        public final Builder packageStatus(String packageStatus) {
            this.packageStatus = packageStatus;
            return this;
        }

        @Override
        public final Builder packageStatus(PackageStatus packageStatus) {
            this.packageStatus(packageStatus == null ? null : packageStatus.toString());
            return this;
        }

        public final void setPackageStatus(String packageStatus) {
            this.packageStatus = packageStatus;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ErrorDetails.Builder getErrorDetails() {
            return this.errorDetails != null ? this.errorDetails.toBuilder() : null;
        }

        @Override
        public final Builder errorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public final void setErrorDetails(ErrorDetails.BuilderImpl errorDetails) {
            this.errorDetails = errorDetails != null ? errorDetails.build() : null;
        }

        public PackageDetails build() {
            return new PackageDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PackageDetails> {
        public Builder packageID(String var1);

        public Builder packageName(String var1);

        public Builder packageType(String var1);

        public Builder packageType(PackageType var1);

        public Builder packageDescription(String var1);

        public Builder packageStatus(String var1);

        public Builder packageStatus(PackageStatus var1);

        public Builder createdAt(Instant var1);

        public Builder errorDetails(ErrorDetails var1);

        default public Builder errorDetails(Consumer<ErrorDetails.Builder> errorDetails) {
            return this.errorDetails((ErrorDetails)((ErrorDetails.Builder)ErrorDetails.builder().applyMutation(errorDetails)).build());
        }
    }
}

