/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.elasticsearch.model.AdvancedOptionsCopier;
import software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptions;
import software.amazon.awssdk.services.elasticsearch.model.CognitoOptions;
import software.amazon.awssdk.services.elasticsearch.model.DomainEndpointOptions;
import software.amazon.awssdk.services.elasticsearch.model.EBSOptions;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchClusterConfig;
import software.amazon.awssdk.services.elasticsearch.model.EncryptionAtRestOptions;
import software.amazon.awssdk.services.elasticsearch.model.EndpointsMapCopier;
import software.amazon.awssdk.services.elasticsearch.model.LogPublishingOption;
import software.amazon.awssdk.services.elasticsearch.model.LogPublishingOptionsCopier;
import software.amazon.awssdk.services.elasticsearch.model.LogType;
import software.amazon.awssdk.services.elasticsearch.model.NodeToNodeEncryptionOptions;
import software.amazon.awssdk.services.elasticsearch.model.ServiceSoftwareOptions;
import software.amazon.awssdk.services.elasticsearch.model.SnapshotOptions;
import software.amazon.awssdk.services.elasticsearch.model.VPCDerivedInfo;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ElasticsearchDomainStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ElasticsearchDomainStatus> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ElasticsearchDomainStatus.getter(ElasticsearchDomainStatus::domainId)).setter(ElasticsearchDomainStatus.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ElasticsearchDomainStatus.getter(ElasticsearchDomainStatus::domainName)).setter(ElasticsearchDomainStatus.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ElasticsearchDomainStatus.getter(ElasticsearchDomainStatus::arn)).setter(ElasticsearchDomainStatus.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()}).build();
    private static final SdkField<Boolean> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ElasticsearchDomainStatus.getter(ElasticsearchDomainStatus::created)).setter(ElasticsearchDomainStatus.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Created").build()}).build();
    private static final SdkField<Boolean> DELETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ElasticsearchDomainStatus.getter(ElasticsearchDomainStatus::deleted)).setter(ElasticsearchDomainStatus.setter(Builder::deleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deleted").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ElasticsearchDomainStatus.getter(ElasticsearchDomainStatus::endpoint)).setter(ElasticsearchDomainStatus.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<Map<String, String>> ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(ElasticsearchDomainStatus.getter(ElasticsearchDomainStatus::endpoints)).setter(ElasticsearchDomainStatus.setter(Builder::endpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoints").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> PROCESSING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ElasticsearchDomainStatus.getter(ElasticsearchDomainStatus::processing)).setter(ElasticsearchDomainStatus.setter(Builder::processing)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Processing").build()}).build();
    private static final SdkField<Boolean> UPGRADE_PROCESSING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ElasticsearchDomainStatus.getter(ElasticsearchDomainStatus::upgradeProcessing)).setter(ElasticsearchDomainStatus.setter(Builder::upgradeProcessing)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpgradeProcessing").build()}).build();
    private static final SdkField<String> ELASTICSEARCH_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ElasticsearchDomainStatus.getter(ElasticsearchDomainStatus::elasticsearchVersion)).setter(ElasticsearchDomainStatus.setter(Builder::elasticsearchVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchVersion").build()}).build();
    private static final SdkField<ElasticsearchClusterConfig> ELASTICSEARCH_CLUSTER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ElasticsearchDomainStatus.getter(ElasticsearchDomainStatus::elasticsearchClusterConfig)).setter(ElasticsearchDomainStatus.setter(Builder::elasticsearchClusterConfig)).constructor(ElasticsearchClusterConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchClusterConfig").build()}).build();
    private static final SdkField<EBSOptions> EBS_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ElasticsearchDomainStatus.getter(ElasticsearchDomainStatus::ebsOptions)).setter(ElasticsearchDomainStatus.setter(Builder::ebsOptions)).constructor(EBSOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EBSOptions").build()}).build();
    private static final SdkField<String> ACCESS_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ElasticsearchDomainStatus.getter(ElasticsearchDomainStatus::accessPolicies)).setter(ElasticsearchDomainStatus.setter(Builder::accessPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPolicies").build()}).build();
    private static final SdkField<SnapshotOptions> SNAPSHOT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ElasticsearchDomainStatus.getter(ElasticsearchDomainStatus::snapshotOptions)).setter(ElasticsearchDomainStatus.setter(Builder::snapshotOptions)).constructor(SnapshotOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotOptions").build()}).build();
    private static final SdkField<VPCDerivedInfo> VPC_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ElasticsearchDomainStatus.getter(ElasticsearchDomainStatus::vpcOptions)).setter(ElasticsearchDomainStatus.setter(Builder::vpcOptions)).constructor(VPCDerivedInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCOptions").build()}).build();
    private static final SdkField<CognitoOptions> COGNITO_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ElasticsearchDomainStatus.getter(ElasticsearchDomainStatus::cognitoOptions)).setter(ElasticsearchDomainStatus.setter(Builder::cognitoOptions)).constructor(CognitoOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CognitoOptions").build()}).build();
    private static final SdkField<EncryptionAtRestOptions> ENCRYPTION_AT_REST_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ElasticsearchDomainStatus.getter(ElasticsearchDomainStatus::encryptionAtRestOptions)).setter(ElasticsearchDomainStatus.setter(Builder::encryptionAtRestOptions)).constructor(EncryptionAtRestOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAtRestOptions").build()}).build();
    private static final SdkField<NodeToNodeEncryptionOptions> NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ElasticsearchDomainStatus.getter(ElasticsearchDomainStatus::nodeToNodeEncryptionOptions)).setter(ElasticsearchDomainStatus.setter(Builder::nodeToNodeEncryptionOptions)).constructor(NodeToNodeEncryptionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeToNodeEncryptionOptions").build()}).build();
    private static final SdkField<Map<String, String>> ADVANCED_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(ElasticsearchDomainStatus.getter(ElasticsearchDomainStatus::advancedOptions)).setter(ElasticsearchDomainStatus.setter(Builder::advancedOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedOptions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, LogPublishingOption>> LOG_PUBLISHING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(ElasticsearchDomainStatus.getter(ElasticsearchDomainStatus::logPublishingOptionsAsStrings)).setter(ElasticsearchDomainStatus.setter(Builder::logPublishingOptionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPublishingOptions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogPublishingOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ServiceSoftwareOptions> SERVICE_SOFTWARE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ElasticsearchDomainStatus.getter(ElasticsearchDomainStatus::serviceSoftwareOptions)).setter(ElasticsearchDomainStatus.setter(Builder::serviceSoftwareOptions)).constructor(ServiceSoftwareOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceSoftwareOptions").build()}).build();
    private static final SdkField<DomainEndpointOptions> DOMAIN_ENDPOINT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ElasticsearchDomainStatus.getter(ElasticsearchDomainStatus::domainEndpointOptions)).setter(ElasticsearchDomainStatus.setter(Builder::domainEndpointOptions)).constructor(DomainEndpointOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainEndpointOptions").build()}).build();
    private static final SdkField<AdvancedSecurityOptions> ADVANCED_SECURITY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ElasticsearchDomainStatus.getter(ElasticsearchDomainStatus::advancedSecurityOptions)).setter(ElasticsearchDomainStatus.setter(Builder::advancedSecurityOptions)).constructor(AdvancedSecurityOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedSecurityOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD, DOMAIN_NAME_FIELD, ARN_FIELD, CREATED_FIELD, DELETED_FIELD, ENDPOINT_FIELD, ENDPOINTS_FIELD, PROCESSING_FIELD, UPGRADE_PROCESSING_FIELD, ELASTICSEARCH_VERSION_FIELD, ELASTICSEARCH_CLUSTER_CONFIG_FIELD, EBS_OPTIONS_FIELD, ACCESS_POLICIES_FIELD, SNAPSHOT_OPTIONS_FIELD, VPC_OPTIONS_FIELD, COGNITO_OPTIONS_FIELD, ENCRYPTION_AT_REST_OPTIONS_FIELD, NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD, ADVANCED_OPTIONS_FIELD, LOG_PUBLISHING_OPTIONS_FIELD, SERVICE_SOFTWARE_OPTIONS_FIELD, DOMAIN_ENDPOINT_OPTIONS_FIELD, ADVANCED_SECURITY_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String domainId;
    private final String domainName;
    private final String arn;
    private final Boolean created;
    private final Boolean deleted;
    private final String endpoint;
    private final Map<String, String> endpoints;
    private final Boolean processing;
    private final Boolean upgradeProcessing;
    private final String elasticsearchVersion;
    private final ElasticsearchClusterConfig elasticsearchClusterConfig;
    private final EBSOptions ebsOptions;
    private final String accessPolicies;
    private final SnapshotOptions snapshotOptions;
    private final VPCDerivedInfo vpcOptions;
    private final CognitoOptions cognitoOptions;
    private final EncryptionAtRestOptions encryptionAtRestOptions;
    private final NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions;
    private final Map<String, String> advancedOptions;
    private final Map<String, LogPublishingOption> logPublishingOptions;
    private final ServiceSoftwareOptions serviceSoftwareOptions;
    private final DomainEndpointOptions domainEndpointOptions;
    private final AdvancedSecurityOptions advancedSecurityOptions;

    private ElasticsearchDomainStatus(BuilderImpl builder) {
        this.domainId = builder.domainId;
        this.domainName = builder.domainName;
        this.arn = builder.arn;
        this.created = builder.created;
        this.deleted = builder.deleted;
        this.endpoint = builder.endpoint;
        this.endpoints = builder.endpoints;
        this.processing = builder.processing;
        this.upgradeProcessing = builder.upgradeProcessing;
        this.elasticsearchVersion = builder.elasticsearchVersion;
        this.elasticsearchClusterConfig = builder.elasticsearchClusterConfig;
        this.ebsOptions = builder.ebsOptions;
        this.accessPolicies = builder.accessPolicies;
        this.snapshotOptions = builder.snapshotOptions;
        this.vpcOptions = builder.vpcOptions;
        this.cognitoOptions = builder.cognitoOptions;
        this.encryptionAtRestOptions = builder.encryptionAtRestOptions;
        this.nodeToNodeEncryptionOptions = builder.nodeToNodeEncryptionOptions;
        this.advancedOptions = builder.advancedOptions;
        this.logPublishingOptions = builder.logPublishingOptions;
        this.serviceSoftwareOptions = builder.serviceSoftwareOptions;
        this.domainEndpointOptions = builder.domainEndpointOptions;
        this.advancedSecurityOptions = builder.advancedSecurityOptions;
    }

    public String domainId() {
        return this.domainId;
    }

    public String domainName() {
        return this.domainName;
    }

    public String arn() {
        return this.arn;
    }

    public Boolean created() {
        return this.created;
    }

    public Boolean deleted() {
        return this.deleted;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public boolean hasEndpoints() {
        return this.endpoints != null && !(this.endpoints instanceof SdkAutoConstructMap);
    }

    public Map<String, String> endpoints() {
        return this.endpoints;
    }

    public Boolean processing() {
        return this.processing;
    }

    public Boolean upgradeProcessing() {
        return this.upgradeProcessing;
    }

    public String elasticsearchVersion() {
        return this.elasticsearchVersion;
    }

    public ElasticsearchClusterConfig elasticsearchClusterConfig() {
        return this.elasticsearchClusterConfig;
    }

    public EBSOptions ebsOptions() {
        return this.ebsOptions;
    }

    public String accessPolicies() {
        return this.accessPolicies;
    }

    public SnapshotOptions snapshotOptions() {
        return this.snapshotOptions;
    }

    public VPCDerivedInfo vpcOptions() {
        return this.vpcOptions;
    }

    public CognitoOptions cognitoOptions() {
        return this.cognitoOptions;
    }

    public EncryptionAtRestOptions encryptionAtRestOptions() {
        return this.encryptionAtRestOptions;
    }

    public NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions() {
        return this.nodeToNodeEncryptionOptions;
    }

    public boolean hasAdvancedOptions() {
        return this.advancedOptions != null && !(this.advancedOptions instanceof SdkAutoConstructMap);
    }

    public Map<String, String> advancedOptions() {
        return this.advancedOptions;
    }

    public Map<LogType, LogPublishingOption> logPublishingOptions() {
        return LogPublishingOptionsCopier.copyStringToEnum(this.logPublishingOptions);
    }

    public boolean hasLogPublishingOptions() {
        return this.logPublishingOptions != null && !(this.logPublishingOptions instanceof SdkAutoConstructMap);
    }

    public Map<String, LogPublishingOption> logPublishingOptionsAsStrings() {
        return this.logPublishingOptions;
    }

    public ServiceSoftwareOptions serviceSoftwareOptions() {
        return this.serviceSoftwareOptions;
    }

    public DomainEndpointOptions domainEndpointOptions() {
        return this.domainEndpointOptions;
    }

    public AdvancedSecurityOptions advancedSecurityOptions() {
        return this.advancedSecurityOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoints());
        hashCode = 31 * hashCode + Objects.hashCode(this.processing());
        hashCode = 31 * hashCode + Objects.hashCode(this.upgradeProcessing());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchClusterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.cognitoOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionAtRestOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeToNodeEncryptionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.advancedOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.logPublishingOptionsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceSoftwareOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainEndpointOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.advancedSecurityOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchDomainStatus)) {
            return false;
        }
        ElasticsearchDomainStatus other = (ElasticsearchDomainStatus)obj;
        return Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.deleted(), other.deleted()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.endpoints(), other.endpoints()) && Objects.equals(this.processing(), other.processing()) && Objects.equals(this.upgradeProcessing(), other.upgradeProcessing()) && Objects.equals(this.elasticsearchVersion(), other.elasticsearchVersion()) && Objects.equals(this.elasticsearchClusterConfig(), other.elasticsearchClusterConfig()) && Objects.equals(this.ebsOptions(), other.ebsOptions()) && Objects.equals(this.accessPolicies(), other.accessPolicies()) && Objects.equals(this.snapshotOptions(), other.snapshotOptions()) && Objects.equals(this.vpcOptions(), other.vpcOptions()) && Objects.equals(this.cognitoOptions(), other.cognitoOptions()) && Objects.equals(this.encryptionAtRestOptions(), other.encryptionAtRestOptions()) && Objects.equals(this.nodeToNodeEncryptionOptions(), other.nodeToNodeEncryptionOptions()) && Objects.equals(this.advancedOptions(), other.advancedOptions()) && Objects.equals(this.logPublishingOptionsAsStrings(), other.logPublishingOptionsAsStrings()) && Objects.equals(this.serviceSoftwareOptions(), other.serviceSoftwareOptions()) && Objects.equals(this.domainEndpointOptions(), other.domainEndpointOptions()) && Objects.equals(this.advancedSecurityOptions(), other.advancedSecurityOptions());
    }

    public String toString() {
        return ToString.builder((String)"ElasticsearchDomainStatus").add("DomainId", (Object)this.domainId()).add("DomainName", (Object)this.domainName()).add("ARN", (Object)this.arn()).add("Created", (Object)this.created()).add("Deleted", (Object)this.deleted()).add("Endpoint", (Object)this.endpoint()).add("Endpoints", this.endpoints()).add("Processing", (Object)this.processing()).add("UpgradeProcessing", (Object)this.upgradeProcessing()).add("ElasticsearchVersion", (Object)this.elasticsearchVersion()).add("ElasticsearchClusterConfig", (Object)this.elasticsearchClusterConfig()).add("EBSOptions", (Object)this.ebsOptions()).add("AccessPolicies", (Object)this.accessPolicies()).add("SnapshotOptions", (Object)this.snapshotOptions()).add("VPCOptions", (Object)this.vpcOptions()).add("CognitoOptions", (Object)this.cognitoOptions()).add("EncryptionAtRestOptions", (Object)this.encryptionAtRestOptions()).add("NodeToNodeEncryptionOptions", (Object)this.nodeToNodeEncryptionOptions()).add("AdvancedOptions", this.advancedOptions()).add("LogPublishingOptions", this.logPublishingOptionsAsStrings()).add("ServiceSoftwareOptions", (Object)this.serviceSoftwareOptions()).add("DomainEndpointOptions", (Object)this.domainEndpointOptions()).add("AdvancedSecurityOptions", (Object)this.advancedSecurityOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "Deleted": {
                return Optional.ofNullable(clazz.cast(this.deleted()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "Endpoints": {
                return Optional.ofNullable(clazz.cast(this.endpoints()));
            }
            case "Processing": {
                return Optional.ofNullable(clazz.cast(this.processing()));
            }
            case "UpgradeProcessing": {
                return Optional.ofNullable(clazz.cast(this.upgradeProcessing()));
            }
            case "ElasticsearchVersion": {
                return Optional.ofNullable(clazz.cast(this.elasticsearchVersion()));
            }
            case "ElasticsearchClusterConfig": {
                return Optional.ofNullable(clazz.cast(this.elasticsearchClusterConfig()));
            }
            case "EBSOptions": {
                return Optional.ofNullable(clazz.cast(this.ebsOptions()));
            }
            case "AccessPolicies": {
                return Optional.ofNullable(clazz.cast(this.accessPolicies()));
            }
            case "SnapshotOptions": {
                return Optional.ofNullable(clazz.cast(this.snapshotOptions()));
            }
            case "VPCOptions": {
                return Optional.ofNullable(clazz.cast(this.vpcOptions()));
            }
            case "CognitoOptions": {
                return Optional.ofNullable(clazz.cast(this.cognitoOptions()));
            }
            case "EncryptionAtRestOptions": {
                return Optional.ofNullable(clazz.cast(this.encryptionAtRestOptions()));
            }
            case "NodeToNodeEncryptionOptions": {
                return Optional.ofNullable(clazz.cast(this.nodeToNodeEncryptionOptions()));
            }
            case "AdvancedOptions": {
                return Optional.ofNullable(clazz.cast(this.advancedOptions()));
            }
            case "LogPublishingOptions": {
                return Optional.ofNullable(clazz.cast(this.logPublishingOptionsAsStrings()));
            }
            case "ServiceSoftwareOptions": {
                return Optional.ofNullable(clazz.cast(this.serviceSoftwareOptions()));
            }
            case "DomainEndpointOptions": {
                return Optional.ofNullable(clazz.cast(this.domainEndpointOptions()));
            }
            case "AdvancedSecurityOptions": {
                return Optional.ofNullable(clazz.cast(this.advancedSecurityOptions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ElasticsearchDomainStatus, T> g) {
        return obj -> g.apply((ElasticsearchDomainStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainId;
        private String domainName;
        private String arn;
        private Boolean created;
        private Boolean deleted;
        private String endpoint;
        private Map<String, String> endpoints = DefaultSdkAutoConstructMap.getInstance();
        private Boolean processing;
        private Boolean upgradeProcessing;
        private String elasticsearchVersion;
        private ElasticsearchClusterConfig elasticsearchClusterConfig;
        private EBSOptions ebsOptions;
        private String accessPolicies;
        private SnapshotOptions snapshotOptions;
        private VPCDerivedInfo vpcOptions;
        private CognitoOptions cognitoOptions;
        private EncryptionAtRestOptions encryptionAtRestOptions;
        private NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions;
        private Map<String, String> advancedOptions = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, LogPublishingOption> logPublishingOptions = DefaultSdkAutoConstructMap.getInstance();
        private ServiceSoftwareOptions serviceSoftwareOptions;
        private DomainEndpointOptions domainEndpointOptions;
        private AdvancedSecurityOptions advancedSecurityOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchDomainStatus model) {
            this.domainId(model.domainId);
            this.domainName(model.domainName);
            this.arn(model.arn);
            this.created(model.created);
            this.deleted(model.deleted);
            this.endpoint(model.endpoint);
            this.endpoints(model.endpoints);
            this.processing(model.processing);
            this.upgradeProcessing(model.upgradeProcessing);
            this.elasticsearchVersion(model.elasticsearchVersion);
            this.elasticsearchClusterConfig(model.elasticsearchClusterConfig);
            this.ebsOptions(model.ebsOptions);
            this.accessPolicies(model.accessPolicies);
            this.snapshotOptions(model.snapshotOptions);
            this.vpcOptions(model.vpcOptions);
            this.cognitoOptions(model.cognitoOptions);
            this.encryptionAtRestOptions(model.encryptionAtRestOptions);
            this.nodeToNodeEncryptionOptions(model.nodeToNodeEncryptionOptions);
            this.advancedOptions(model.advancedOptions);
            this.logPublishingOptionsWithStrings(model.logPublishingOptions);
            this.serviceSoftwareOptions(model.serviceSoftwareOptions);
            this.domainEndpointOptions(model.domainEndpointOptions);
            this.advancedSecurityOptions(model.advancedSecurityOptions);
        }

        public final String getDomainId() {
            return this.domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Boolean getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Boolean created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Boolean created) {
            this.created = created;
        }

        public final Boolean getDeleted() {
            return this.deleted;
        }

        @Override
        public final Builder deleted(Boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public final void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final Map<String, String> getEndpoints() {
            return this.endpoints;
        }

        @Override
        public final Builder endpoints(Map<String, String> endpoints) {
            this.endpoints = EndpointsMapCopier.copy(endpoints);
            return this;
        }

        public final void setEndpoints(Map<String, String> endpoints) {
            this.endpoints = EndpointsMapCopier.copy(endpoints);
        }

        public final Boolean getProcessing() {
            return this.processing;
        }

        @Override
        public final Builder processing(Boolean processing) {
            this.processing = processing;
            return this;
        }

        public final void setProcessing(Boolean processing) {
            this.processing = processing;
        }

        public final Boolean getUpgradeProcessing() {
            return this.upgradeProcessing;
        }

        @Override
        public final Builder upgradeProcessing(Boolean upgradeProcessing) {
            this.upgradeProcessing = upgradeProcessing;
            return this;
        }

        public final void setUpgradeProcessing(Boolean upgradeProcessing) {
            this.upgradeProcessing = upgradeProcessing;
        }

        public final String getElasticsearchVersion() {
            return this.elasticsearchVersion;
        }

        @Override
        public final Builder elasticsearchVersion(String elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
            return this;
        }

        public final void setElasticsearchVersion(String elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
        }

        public final ElasticsearchClusterConfig.Builder getElasticsearchClusterConfig() {
            return this.elasticsearchClusterConfig != null ? this.elasticsearchClusterConfig.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearchClusterConfig(ElasticsearchClusterConfig elasticsearchClusterConfig) {
            this.elasticsearchClusterConfig = elasticsearchClusterConfig;
            return this;
        }

        public final void setElasticsearchClusterConfig(ElasticsearchClusterConfig.BuilderImpl elasticsearchClusterConfig) {
            this.elasticsearchClusterConfig = elasticsearchClusterConfig != null ? elasticsearchClusterConfig.build() : null;
        }

        public final EBSOptions.Builder getEbsOptions() {
            return this.ebsOptions != null ? this.ebsOptions.toBuilder() : null;
        }

        @Override
        public final Builder ebsOptions(EBSOptions ebsOptions) {
            this.ebsOptions = ebsOptions;
            return this;
        }

        public final void setEbsOptions(EBSOptions.BuilderImpl ebsOptions) {
            this.ebsOptions = ebsOptions != null ? ebsOptions.build() : null;
        }

        public final String getAccessPolicies() {
            return this.accessPolicies;
        }

        @Override
        public final Builder accessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
            return this;
        }

        public final void setAccessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
        }

        public final SnapshotOptions.Builder getSnapshotOptions() {
            return this.snapshotOptions != null ? this.snapshotOptions.toBuilder() : null;
        }

        @Override
        public final Builder snapshotOptions(SnapshotOptions snapshotOptions) {
            this.snapshotOptions = snapshotOptions;
            return this;
        }

        public final void setSnapshotOptions(SnapshotOptions.BuilderImpl snapshotOptions) {
            this.snapshotOptions = snapshotOptions != null ? snapshotOptions.build() : null;
        }

        public final VPCDerivedInfo.Builder getVpcOptions() {
            return this.vpcOptions != null ? this.vpcOptions.toBuilder() : null;
        }

        @Override
        public final Builder vpcOptions(VPCDerivedInfo vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        public final void setVpcOptions(VPCDerivedInfo.BuilderImpl vpcOptions) {
            this.vpcOptions = vpcOptions != null ? vpcOptions.build() : null;
        }

        public final CognitoOptions.Builder getCognitoOptions() {
            return this.cognitoOptions != null ? this.cognitoOptions.toBuilder() : null;
        }

        @Override
        public final Builder cognitoOptions(CognitoOptions cognitoOptions) {
            this.cognitoOptions = cognitoOptions;
            return this;
        }

        public final void setCognitoOptions(CognitoOptions.BuilderImpl cognitoOptions) {
            this.cognitoOptions = cognitoOptions != null ? cognitoOptions.build() : null;
        }

        public final EncryptionAtRestOptions.Builder getEncryptionAtRestOptions() {
            return this.encryptionAtRestOptions != null ? this.encryptionAtRestOptions.toBuilder() : null;
        }

        @Override
        public final Builder encryptionAtRestOptions(EncryptionAtRestOptions encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions;
            return this;
        }

        public final void setEncryptionAtRestOptions(EncryptionAtRestOptions.BuilderImpl encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions != null ? encryptionAtRestOptions.build() : null;
        }

        public final NodeToNodeEncryptionOptions.Builder getNodeToNodeEncryptionOptions() {
            return this.nodeToNodeEncryptionOptions != null ? this.nodeToNodeEncryptionOptions.toBuilder() : null;
        }

        @Override
        public final Builder nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions;
            return this;
        }

        public final void setNodeToNodeEncryptionOptions(NodeToNodeEncryptionOptions.BuilderImpl nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions != null ? nodeToNodeEncryptionOptions.build() : null;
        }

        public final Map<String, String> getAdvancedOptions() {
            return this.advancedOptions;
        }

        @Override
        public final Builder advancedOptions(Map<String, String> advancedOptions) {
            this.advancedOptions = AdvancedOptionsCopier.copy(advancedOptions);
            return this;
        }

        public final void setAdvancedOptions(Map<String, String> advancedOptions) {
            this.advancedOptions = AdvancedOptionsCopier.copy(advancedOptions);
        }

        public final Map<String, LogPublishingOption.Builder> getLogPublishingOptions() {
            return this.logPublishingOptions != null ? CollectionUtils.mapValues(this.logPublishingOptions, LogPublishingOption::toBuilder) : null;
        }

        @Override
        public final Builder logPublishingOptionsWithStrings(Map<String, LogPublishingOption> logPublishingOptions) {
            this.logPublishingOptions = LogPublishingOptionsCopier.copy(logPublishingOptions);
            return this;
        }

        @Override
        public final Builder logPublishingOptions(Map<LogType, LogPublishingOption> logPublishingOptions) {
            this.logPublishingOptions = LogPublishingOptionsCopier.copyEnumToString(logPublishingOptions);
            return this;
        }

        public final void setLogPublishingOptions(Map<String, LogPublishingOption.BuilderImpl> logPublishingOptions) {
            this.logPublishingOptions = LogPublishingOptionsCopier.copyFromBuilder(logPublishingOptions);
        }

        public final ServiceSoftwareOptions.Builder getServiceSoftwareOptions() {
            return this.serviceSoftwareOptions != null ? this.serviceSoftwareOptions.toBuilder() : null;
        }

        @Override
        public final Builder serviceSoftwareOptions(ServiceSoftwareOptions serviceSoftwareOptions) {
            this.serviceSoftwareOptions = serviceSoftwareOptions;
            return this;
        }

        public final void setServiceSoftwareOptions(ServiceSoftwareOptions.BuilderImpl serviceSoftwareOptions) {
            this.serviceSoftwareOptions = serviceSoftwareOptions != null ? serviceSoftwareOptions.build() : null;
        }

        public final DomainEndpointOptions.Builder getDomainEndpointOptions() {
            return this.domainEndpointOptions != null ? this.domainEndpointOptions.toBuilder() : null;
        }

        @Override
        public final Builder domainEndpointOptions(DomainEndpointOptions domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions;
            return this;
        }

        public final void setDomainEndpointOptions(DomainEndpointOptions.BuilderImpl domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions != null ? domainEndpointOptions.build() : null;
        }

        public final AdvancedSecurityOptions.Builder getAdvancedSecurityOptions() {
            return this.advancedSecurityOptions != null ? this.advancedSecurityOptions.toBuilder() : null;
        }

        @Override
        public final Builder advancedSecurityOptions(AdvancedSecurityOptions advancedSecurityOptions) {
            this.advancedSecurityOptions = advancedSecurityOptions;
            return this;
        }

        public final void setAdvancedSecurityOptions(AdvancedSecurityOptions.BuilderImpl advancedSecurityOptions) {
            this.advancedSecurityOptions = advancedSecurityOptions != null ? advancedSecurityOptions.build() : null;
        }

        public ElasticsearchDomainStatus build() {
            return new ElasticsearchDomainStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ElasticsearchDomainStatus> {
        public Builder domainId(String var1);

        public Builder domainName(String var1);

        public Builder arn(String var1);

        public Builder created(Boolean var1);

        public Builder deleted(Boolean var1);

        public Builder endpoint(String var1);

        public Builder endpoints(Map<String, String> var1);

        public Builder processing(Boolean var1);

        public Builder upgradeProcessing(Boolean var1);

        public Builder elasticsearchVersion(String var1);

        public Builder elasticsearchClusterConfig(ElasticsearchClusterConfig var1);

        default public Builder elasticsearchClusterConfig(Consumer<ElasticsearchClusterConfig.Builder> elasticsearchClusterConfig) {
            return this.elasticsearchClusterConfig((ElasticsearchClusterConfig)((ElasticsearchClusterConfig.Builder)ElasticsearchClusterConfig.builder().applyMutation(elasticsearchClusterConfig)).build());
        }

        public Builder ebsOptions(EBSOptions var1);

        default public Builder ebsOptions(Consumer<EBSOptions.Builder> ebsOptions) {
            return this.ebsOptions((EBSOptions)((EBSOptions.Builder)EBSOptions.builder().applyMutation(ebsOptions)).build());
        }

        public Builder accessPolicies(String var1);

        public Builder snapshotOptions(SnapshotOptions var1);

        default public Builder snapshotOptions(Consumer<SnapshotOptions.Builder> snapshotOptions) {
            return this.snapshotOptions((SnapshotOptions)((SnapshotOptions.Builder)SnapshotOptions.builder().applyMutation(snapshotOptions)).build());
        }

        public Builder vpcOptions(VPCDerivedInfo var1);

        default public Builder vpcOptions(Consumer<VPCDerivedInfo.Builder> vpcOptions) {
            return this.vpcOptions((VPCDerivedInfo)((VPCDerivedInfo.Builder)VPCDerivedInfo.builder().applyMutation(vpcOptions)).build());
        }

        public Builder cognitoOptions(CognitoOptions var1);

        default public Builder cognitoOptions(Consumer<CognitoOptions.Builder> cognitoOptions) {
            return this.cognitoOptions((CognitoOptions)((CognitoOptions.Builder)CognitoOptions.builder().applyMutation(cognitoOptions)).build());
        }

        public Builder encryptionAtRestOptions(EncryptionAtRestOptions var1);

        default public Builder encryptionAtRestOptions(Consumer<EncryptionAtRestOptions.Builder> encryptionAtRestOptions) {
            return this.encryptionAtRestOptions((EncryptionAtRestOptions)((EncryptionAtRestOptions.Builder)EncryptionAtRestOptions.builder().applyMutation(encryptionAtRestOptions)).build());
        }

        public Builder nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptions var1);

        default public Builder nodeToNodeEncryptionOptions(Consumer<NodeToNodeEncryptionOptions.Builder> nodeToNodeEncryptionOptions) {
            return this.nodeToNodeEncryptionOptions((NodeToNodeEncryptionOptions)((NodeToNodeEncryptionOptions.Builder)NodeToNodeEncryptionOptions.builder().applyMutation(nodeToNodeEncryptionOptions)).build());
        }

        public Builder advancedOptions(Map<String, String> var1);

        public Builder logPublishingOptionsWithStrings(Map<String, LogPublishingOption> var1);

        public Builder logPublishingOptions(Map<LogType, LogPublishingOption> var1);

        public Builder serviceSoftwareOptions(ServiceSoftwareOptions var1);

        default public Builder serviceSoftwareOptions(Consumer<ServiceSoftwareOptions.Builder> serviceSoftwareOptions) {
            return this.serviceSoftwareOptions((ServiceSoftwareOptions)((ServiceSoftwareOptions.Builder)ServiceSoftwareOptions.builder().applyMutation(serviceSoftwareOptions)).build());
        }

        public Builder domainEndpointOptions(DomainEndpointOptions var1);

        default public Builder domainEndpointOptions(Consumer<DomainEndpointOptions.Builder> domainEndpointOptions) {
            return this.domainEndpointOptions((DomainEndpointOptions)((DomainEndpointOptions.Builder)DomainEndpointOptions.builder().applyMutation(domainEndpointOptions)).build());
        }

        public Builder advancedSecurityOptions(AdvancedSecurityOptions var1);

        default public Builder advancedSecurityOptions(Consumer<AdvancedSecurityOptions.Builder> advancedSecurityOptions) {
            return this.advancedSecurityOptions((AdvancedSecurityOptions)((AdvancedSecurityOptions.Builder)AdvancedSecurityOptions.builder().applyMutation(advancedSecurityOptions)).build());
        }
    }
}

